/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;

public class RbelArrayUtils {
    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (array == prefix) {
            return true;
        }
        if (array == null || prefix == null) {
            return false;
        }
        int prefixLength = prefix.length;
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefixLength; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] sliceArrayAtMarker(byte[] array, byte[] marker, int searchOffset) {
        if (array == marker || array == null || marker == null) {
            throw new IllegalArgumentException();
        }
        int markerLength = marker.length;
        if (markerLength > array.length) {
            throw new IllegalArgumentException();
        }
        int indexOf = RbelArrayUtils.indexOf(array, marker, searchOffset);
        return Arrays.copyOfRange(array, indexOf, indexOf + markerLength);
    }

    public static int indexOf(byte[] outerArray, byte[] smallerArray, int searchOffset) {
        for (int i = searchOffset; i < outerArray.length - smallerArray.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (outerArray[i + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    private static boolean startsWithIgnoreCaseInternal(byte[] content, byte[] prefix, int startInclusive) {
        String prefixString = new String(prefix, StandardCharsets.UTF_8);
        return new String(content, startInclusive, prefix.length, StandardCharsets.UTF_8).equalsIgnoreCase(prefixString);
    }

    private static boolean startsWithInternal(byte[] content, byte[] searchContent, int startIndex) {
        int j = 0;
        int k = startIndex;
        while (j < searchContent.length) {
            if (content[k] != searchContent[j]) {
                return false;
            }
            ++j;
            ++k;
        }
        return true;
    }

    public static boolean startsTrimmedWith(byte[] content, byte[] firstNonBlankBytes) {
        return RbelArrayUtils.startsTrimmedWith(content, firstNonBlankBytes, false);
    }

    public static boolean startsTrimmedWith(byte[] content, byte[] firstNonBlankBytes, boolean ignoreCase) {
        for (int i = 0; i < content.length; ++i) {
            if (Character.isWhitespace(content[i])) continue;
            if (i + firstNonBlankBytes.length > content.length) {
                return false;
            }
            if (ignoreCase) {
                return RbelArrayUtils.startsWithIgnoreCaseInternal(content, firstNonBlankBytes, i);
            }
            return RbelArrayUtils.startsWithInternal(content, firstNonBlankBytes, i);
        }
        return false;
    }

    public static boolean endsTrimmedWith(byte[] content, byte[] lastNonBlankBytes) {
        return RbelArrayUtils.endsTrimmedWith(content, lastNonBlankBytes, false);
    }

    public static boolean endsTrimmedWith(byte[] content, byte[] lastNonBlankBytes, boolean ignoreCase) {
        int i = content.length;
        while (i-- > 0) {
            if (Character.isWhitespace(content[i])) continue;
            int beginIndex = i - lastNonBlankBytes.length + 1;
            if (beginIndex < 0) {
                return false;
            }
            if (ignoreCase) {
                return RbelArrayUtils.startsWithIgnoreCaseInternal(content, lastNonBlankBytes, beginIndex);
            }
            return RbelArrayUtils.startsWithInternal(content, lastNonBlankBytes, beginIndex);
        }
        return false;
    }

    public static boolean endsWith(byte[] content, byte[] postfix) {
        if (postfix.length > content.length) {
            return false;
        }
        int postfixIndex = postfix.length - 1;
        int contentIndex = content.length - 1;
        while (postfixIndex >= 0) {
            if (postfix[postfixIndex] != content[contentIndex]) {
                return false;
            }
            --postfixIndex;
            --contentIndex;
        }
        return true;
    }

    @Generated
    private RbelArrayUtils() {
    }
}

