/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class GenericPrettyPrinter<T> {
    private final Predicate<T> isLeaf;
    private final Function<T, String> leafPrinter;
    private final Function<T, Stream<T>> leafRetriever;
    private Function<T, String> nodeIntroPrinter = t -> "";
    private String openingBrace = "[";
    private String closingBrace = "]";
    private String depthStepper = "\t";

    public String prettyPrint(T root) {
        return this.prettyPrint(root, 0);
    }

    private String prettyPrint(T node, int depth) {
        if (this.isLeaf.test(node)) {
            return this.depthStepper.repeat(depth) + this.leafPrinter.apply(node);
        }
        return this.depthStepper.repeat(depth) + this.nodeIntroPrinter.apply(node) + this.openingBrace + "\n" + this.leafRetriever.apply(node).map(leaf -> this.prettyPrint(leaf, depth + 1)).collect(Collectors.joining(",\n")) + "\n" + this.depthStepper.repeat(depth) + this.closingBrace;
    }

    @ConstructorProperties(value={"isLeaf", "leafPrinter", "leafRetriever"})
    @Generated
    public GenericPrettyPrinter(Predicate<T> isLeaf, Function<T, String> leafPrinter, Function<T, Stream<T>> leafRetriever) {
        this.isLeaf = isLeaf;
        this.leafPrinter = leafPrinter;
        this.leafRetriever = leafRetriever;
    }

    @Generated
    public void setNodeIntroPrinter(Function<T, String> nodeIntroPrinter) {
        this.nodeIntroPrinter = nodeIntroPrinter;
    }
}

