/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.util.RbelContent;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.GCMParameterSpec;
import lombok.Generated;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptoUtils {
    public static final int GCM_IV_LENGTH_IN_BYTES = 12;
    public static final int GCM_TAG_LENGTH_IN_BYTES = 16;
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();

    public static byte[] ecka(PrivateKey prk, PublicKey puk) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement ka = KeyAgreement.getInstance("ECDH", (Provider)BOUNCY_CASTLE_PROVIDER);
        ka.init(prk);
        ka.doPhase(puk, true);
        byte[] sharedSecret = ka.generateSecret();
        return sharedSecret;
    }

    public static byte[] hkdf(byte[] ikm, String info, int lengthInBytes) throws IllegalArgumentException, DataLengthException {
        return CryptoUtils.hkdf(ikm, info.getBytes(StandardCharsets.UTF_8), lengthInBytes);
    }

    public static byte[] hkdf(byte[] ikm, byte[] info, int lengthInBytes) throws IllegalArgumentException, DataLengthException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, null, info));
        byte[] okm = new byte[lengthInBytes];
        hkdf.generateBytes(okm, 0, lengthInBytes);
        return okm;
    }

    public static Optional<byte[]> decrypt(RbelContent encMessage, Key secretKey) {
        return CryptoUtils.decrypt(encMessage, secretKey, 12, 16);
    }

    public static Optional<byte[]> decrypt(RbelContent encMessage, Key secretKey, int gcmIvLengthInBytes, int gcmTagLengthInBytes) {
        try {
            return Optional.ofNullable(CryptoUtils.decryptUnsafe(encMessage, secretKey, gcmIvLengthInBytes, gcmTagLengthInBytes));
        }
        catch (RuntimeException | GeneralSecurityException e) {
            return Optional.empty();
        }
    }

    public static byte[] decryptUnsafe(RbelContent encMessage, Key secretKey, int gcmIvLengthInBytes, int gcmTagLengthInBytes) throws GeneralSecurityException {
        byte[] iv = encMessage.toByteArray(0, gcmIvLengthInBytes);
        byte[] cipherText = encMessage.toByteArray(12, encMessage.size());
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", (Provider)BOUNCY_CASTLE_PROVIDER);
        cipher.init(2, secretKey, new GCMParameterSpec(gcmTagLengthInBytes * 8, iv));
        return cipher.doFinal(cipherText);
    }

    @Generated
    private CryptoUtils() {
    }
}

