/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterPluginMap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConverterPluginMap.class);
    private static final OrderedSet EMPTY_ORDERED_SET = new OrderedSet();
    private final Map<RbelConversionPhase, OrderedSet> source = new ConcurrentHashMap<RbelConversionPhase, OrderedSet>();

    public void put(RbelConverterPlugin value) {
        this.source.computeIfAbsent(value.getPhase(), k -> new OrderedSet()).add(value);
    }

    public void clear() {
        this.source.clear();
    }

    public OrderedSet get(RbelConversionPhase key) {
        return this.source.getOrDefault((Object)key, EMPTY_ORDERED_SET);
    }

    public void forEach(Consumer<RbelConverterPlugin> pluginConsumer) {
        this.source.values().forEach((? super T orderedSet) -> orderedSet.forEach(pluginConsumer));
    }

    public Stream<RbelConverterPlugin> stream() {
        return this.source.values().stream().flatMap(OrderedSet::stream);
    }

    public void addAll(ConverterPluginMap converterPlugins) {
        converterPlugins.forEach(this::put);
    }

    public static class OrderedSet
    implements Iterable<RbelConverterPlugin> {
        private final ConcurrentSkipListSet<Entry> set = new ConcurrentSkipListSet();
        private final AtomicLong insertionOrder = new AtomicLong(0L);

        public void add(RbelConverterPlugin item) {
            this.set.add(new Entry(item, this.insertionOrder.getAndIncrement()));
        }

        public void clear() {
            this.set.clear();
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public int size() {
            return this.set.size();
        }

        public ConcurrentSkipListSet<Entry> getSet() {
            return this.set;
        }

        @Override
        public Iterator<RbelConverterPlugin> iterator() {
            return new Iterator<RbelConverterPlugin>(){
                private final Iterator<Entry> iterator;
                {
                    this.iterator = set.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public RbelConverterPlugin next() {
                    return this.iterator.next().getValue();
                }
            };
        }

        public Stream<RbelConverterPlugin> stream() {
            return this.set.stream().map(Entry::getValue);
        }

        private static class Entry
        implements Comparable<Entry> {
            private final RbelConverterPlugin value;
            private final long order;

            @Override
            public int compareTo(Entry other) {
                int comparison = -this.comparePhasesAndPriority(other);
                if (comparison != 0) {
                    return comparison;
                }
                return Long.compare(this.order, other.order);
            }

            private int comparePhasesAndPriority(Entry other) {
                int phaseComparison = this.getValue().getPhase().compareTo(other.getValue().getPhase());
                if (phaseComparison != 0) {
                    return phaseComparison;
                }
                return Integer.compare(this.getValue().getPriority(), other.getValue().getPriority());
            }

            @Generated
            public RbelConverterPlugin getValue() {
                return this.value;
            }

            @Generated
            public long getOrder() {
                return this.order;
            }

            @ConstructorProperties(value={"value", "order"})
            @Generated
            public Entry(RbelConverterPlugin value, long order) {
                this.value = value;
                this.order = order;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getOrder() != other.getOrder()) {
                    return false;
                }
                RbelConverterPlugin this$value = this.getValue();
                RbelConverterPlugin other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $order = this.getOrder();
                result = result * 59 + (int)($order >>> 32 ^ $order);
                RbelConverterPlugin $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }
}

