/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.testutil;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelValueFacet;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.StringAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelElementAssertion
extends AbstractAssert<RbelElementAssertion, RbelElement> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelElementAssertion.class);
    private final RbelElement initial;
    private boolean printTreeOnError = false;

    public RbelElementAssertion(RbelElement actual) {
        super((Object)actual, RbelElementAssertion.class);
        this.initial = actual;
        this.hasCorrectParentKeysSetInAllElements(actual);
    }

    private RbelElementAssertion(RbelElement actual, RbelElement initial) {
        super((Object)actual, RbelElementAssertion.class);
        this.initial = initial;
        this.hasCorrectParentKeysSetInAllElements(actual);
    }

    public static RbelElementAssertion assertThat(RbelElement actual) {
        return new RbelElementAssertion(actual);
    }

    public RbelElementAssertion extractChildWithPath(String rbelPath) {
        List<RbelElement> kids = ((RbelElement)this.actual).findRbelPathMembers(rbelPath);
        if (kids.isEmpty()) {
            this.failWithMessage("Expected rbelPath %s to find member, but did not in tree %s", rbelPath, ((RbelElement)this.actual).printTreeStructureWithoutColors());
        }
        if (kids.size() > 1) {
            this.failWithMessage("Expected rbelPath %s to find one member, but did return %s \n(%s) \nin tree %s", rbelPath, kids.size(), kids.stream().map(RbelPathAble::findNodePath).collect(Collectors.joining("\n")), ((RbelElement)this.actual).printTreeStructureWithoutColors());
        }
        return new RbelElementAssertion(kids.get(0), (RbelElement)this.actual);
    }

    public RbelElementAssertion hasGivenValueAtPosition(String rbelPath, Object expectedValue) {
        try {
            this.extractChildWithPath(rbelPath).hasValueEqualTo(expectedValue);
            return this;
        }
        catch (AssertionError e) {
            this.printTree();
            throw e;
        }
    }

    public RbelElementAssertion hasGivenFacetAtPosition(String rbelPath, Class<? extends RbelFacet> expectedFacet) {
        try {
            this.extractChildWithPath(rbelPath).hasFacet(expectedFacet);
            return this;
        }
        catch (AssertionError e) {
            this.printTree();
            throw e;
        }
    }

    public RbelElementAssertion hasStringContentEqualToAtPosition(String rbelPath, String expectedValue) {
        try {
            this.extractChildWithPath(rbelPath).hasStringContentEqualTo(expectedValue);
        }
        catch (AssertionError e) {
            this.printTree();
            throw e;
        }
        return this;
    }

    public RbelElementAssertion extractChildWithPath(String rbelPath, int index) {
        List<RbelElement> kids = ((RbelElement)this.actual).findRbelPathMembers(rbelPath);
        if (kids.isEmpty()) {
            this.failWithMessage("Expected rbelPath %s to find member, but did not in tree %s", rbelPath, ((RbelElement)this.actual).printTreeStructureWithoutColors());
        }
        if (kids.size() <= index) {
            this.failWithMessage("Expected rbelPath %s to find %s member, but did return %s \n(%s) \nin tree %s", rbelPath, index, kids.size(), kids.stream().map(RbelPathAble::findNodePath).collect(Collectors.joining("\n")), ((RbelElement)this.actual).printTreeStructureWithoutColors());
        }
        return new RbelElementAssertion(kids.get(index), (RbelElement)this.actual);
    }

    public RbelElementAssertion hasChildWithPath(String rbelPath) {
        this.extractChildWithPath(rbelPath);
        return this;
    }

    public RbelElementAssertion doesNotHaveChildWithPath(String rbelPath) {
        List<RbelElement> kids = ((RbelElement)this.actual).findRbelPathMembers(rbelPath);
        if (!kids.isEmpty()) {
            this.failWithMessage("Expected rbelPath $s not to find anything, but found %s", rbelPath, kids);
        }
        return (RbelElementAssertion)this.myself;
    }

    public RbelElementAssertion andTheInitialElement() {
        return new RbelElementAssertion(this.initial);
    }

    public RbelElementAssertion hasStringContentEqualTo(String expectedToString) {
        try {
            this.objects.assertHasToString((AssertionInfo)this.info, (Object)((RbelElement)this.actual).getRawStringContent(), expectedToString);
            return (RbelElementAssertion)this.myself;
        }
        catch (AssertionError e) {
            this.printTree();
            throw e;
        }
    }

    public RbelElementAssertion hasNullContent() {
        if (((RbelElement)this.actual).getRawContent() != null) {
            this.failWithMessage("Expecting null content, but found %s", ((RbelElement)this.actual).getRawStringContent());
        }
        return (RbelElementAssertion)this.myself;
    }

    public StringAssert asString() {
        return new StringAssert(((RbelElement)this.actual).getRawStringContent());
    }

    public RbelElementAssertion hasFacet(Class<? extends RbelFacet> facetToTest) {
        if (!((RbelElement)this.actual).hasFacet(facetToTest)) {
            this.failWithMessage("Expecting element to have facet of type %s, but only found facets %s", facetToTest.getSimpleName(), new ArrayList<RbelFacet>(((RbelElement)this.actual).getFacets()));
        }
        return (RbelElementAssertion)this.myself;
    }

    public ByteArrayAssert getContent() {
        return new ByteArrayAssert(((RbelElement)this.actual).getRawContent());
    }

    public OptionalAssert<String> valueAsString() {
        return AssertionsForClassTypes.assertThat(((RbelElement)this.actual).printValue());
    }

    public RbelElementAssertion doesNotHaveFacet(Class<? extends RbelFacet> facetToTest) {
        if (((RbelElement)this.actual).hasFacet(facetToTest)) {
            this.failWithMessage("    Expecting element to have NOT facet of type %s, but it was found along with \n%s \n \n\n    at element:\n    $.%s\n", facetToTest.getSimpleName(), new ArrayList<RbelFacet>(((RbelElement)this.actual).getFacets()), ((RbelElement)this.actual).findNodePath());
        }
        return (RbelElementAssertion)this.myself;
    }

    public RbelElementAssertion hasValueEqualTo(Object expected) {
        this.hasFacet(RbelValueFacet.class);
        Object actualValue = ((RbelElement)this.actual).getFacetOrFail(RbelValueFacet.class).getValue();
        ((ObjectAssert)Assertions.assertThat(actualValue).as("Checking value at position $.%s", new Object[]{((RbelElement)this.actual).findNodePath()})).isEqualTo(expected);
        return (RbelElementAssertion)this.myself;
    }

    public <F extends RbelFacet> ObjectAssert<F> extractFacet(Class<F> facetClass) {
        if (!((RbelElement)this.actual).hasFacet(facetClass)) {
            this.failWithMessage("Expecting element to have facet of type %s, but only found facets %s", facetClass.getSimpleName(), new ArrayList<RbelFacet>(((RbelElement)this.actual).getFacets()));
        }
        return new ObjectAssert(((RbelElement)this.actual).getFacetOrFail(facetClass));
    }

    protected void failWithMessage(String errorMessage, Object ... arguments) {
        this.printTree();
        super.failWithMessage(errorMessage, arguments);
    }

    public RbelElementAssertion andPrintTree() {
        this.printTreeOnError = true;
        return this;
    }

    private void printTree() {
        if (this.printTreeOnError) {
            log.info(((RbelElement)this.actual).printTreeStructure());
            this.printTreeOnError = false;
        }
    }

    public RbelElementAssertion matchesJexlExpression(String jexlExpression) {
        if (!TigerJexlExecutor.matchesAsJexlExpression((Object)this.actual, (String)jexlExpression)) {
            this.failWithMessage("Expecting element to match jexl expression %s, but it did not. Element: %s", jexlExpression, ((RbelElement)this.actual).printTreeStructure());
        }
        return this;
    }

    public ListAssert<RbelElement> getChildrenWithPath(String rbelPath) {
        return new ListAssert(((RbelElement)this.actual).findRbelPathMembers(rbelPath));
    }

    private void hasCorrectParentKeysSetInAllElements(RbelElement actual) {
        for (Map.Entry<String, RbelElement> child : actual.getChildNodesWithKey().entries()) {
            if (child.getValue().getParentNode() != actual) {
                log.error(actual.findRootElement().printTreeStructure());
                this.failWithMessage("Expecting all parents to be correct. Fail for child $.%s of element $.%s", child.getKey(), actual.findNodePath());
            }
            this.hasCorrectParentKeysSetInAllElements(child.getValue());
        }
    }

    public RbelElementAssertion hasCharset(Charset charset) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((RbelElement)this.actual).getElementCharset()).as("Checking charset of element at position $.%s", new Object[]{((RbelElement)this.actual).findNodePath()})).isEqualTo((Object)charset);
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelElementAssertion)) {
            return false;
        }
        RbelElementAssertion other = (RbelElementAssertion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.printTreeOnError != other.printTreeOnError) {
            return false;
        }
        RbelElement this$initial = this.initial;
        RbelElement other$initial = other.initial;
        return !(this$initial == null ? other$initial != null : !this$initial.equals(other$initial));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelElementAssertion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.printTreeOnError ? 79 : 97);
        RbelElement $initial = this.initial;
        result = result * 59 + ($initial == null ? 43 : $initial.hashCode());
        return result;
    }
}

