/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelMessageInfoFacet;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.timing.RbelMessageTimingFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H1Tag;
import j2html.tags.specialized.ITag;
import j2html.tags.specialized.SpanTag;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class RbelMessageRenderer
implements RbelHtmlFacetRenderer {
    public static final DomContent RENDER_FULLY_BUTTON = TagCreator.span().with((DomContent)((ATag)((ATag)TagCreator.a().withTitle("Full Message")).withClass("btn modal-button full-message-button float-end mx-2 test-modal-full-render")).with((DomContent)((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)TagCreator.i().withClass("fas fa-expand"))));

    public static ContainerTag buildAddressInfo(RbelElement element) {
        String icon;
        String right;
        String left;
        Optional<RbelTcpIpMessageFacet> messageFacet = element.getFacet(RbelTcpIpMessageFacet.class);
        String senderHostname = messageFacet.map(RbelTcpIpMessageFacet::getSender).flatMap(f -> f.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).orElse(null);
        String receiverHostname = messageFacet.map(RbelTcpIpMessageFacet::getReceiver).flatMap(f -> f.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).orElse(null);
        if (senderHostname == null && receiverHostname == null) {
            return TagCreator.span();
        }
        if (RbelMessageRenderer.isRequestMessage(element)) {
            left = senderHostname;
            right = receiverHostname;
            icon = "fa-arrow-right";
        } else {
            left = receiverHostname;
            right = senderHostname;
            icon = "fa-arrow-left";
        }
        return (ContainerTag)((SpanTag)((SpanTag)((SpanTag)TagCreator.span().withText(left == null ? "" : left)).with((DomContent)RbelHtmlRenderingToolkit.icon(icon))).with((DomContent)TagCreator.text((String)(right == null ? "" : right)))).withClass("is-size-7 ms-4");
    }

    private static boolean isRequestMessage(RbelElement element) {
        return element.hasFacet(RbelRequestFacet.class) || !element.hasFacet(RbelResponseFacet.class);
    }

    public static ContainerTag buildTimingInfo(RbelElement element) {
        if (!element.hasFacet(RbelMessageTimingFacet.class)) {
            return TagCreator.span();
        }
        RbelMessageTimingFacet timingFacet = element.getFacetOrFail(RbelMessageTimingFacet.class);
        return (ContainerTag)((SpanTag)((SpanTag)TagCreator.span().with((DomContent)RbelHtmlRenderingToolkit.icon("fa-clock"))).withText(timingFacet.getTransmissionTime().format(DateTimeFormatter.ISO_TIME))).withClass("is-size-7 ms-4 ");
    }

    @Override
    public boolean checkForRendering(RbelElement element) {
        return element.hasFacet(RbelHttpMessageFacet.class) && element.getParentNode() != null;
    }

    @Override
    public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
        Optional<RbelHttpMessageFacet> httpMessageFacet = element.getFacet(RbelHttpMessageFacet.class);
        Optional<RbelHttpRequestFacet> httpRequestFacet = element.getFacet(RbelHttpRequestFacet.class);
        Optional<RbelMessageInfoFacet> messageInfoFacet = element.getFacet(RbelMessageInfoFacet.class);
        Optional<RbelElement> partnerMessage = this.findPartner(element);
        boolean showExpanded = renderingToolkit.showElementExpanded(element);
        ArrayList<Object> messageTitleElements = new ArrayList<Object>();
        messageTitleElements.add(TagCreator.a().attr("name", (Object)element.getUuid()));
        messageTitleElements.add(RbelMessageRenderer.showBodyToggleButton(showExpanded, "msg-toggle", messageInfoFacet));
        messageTitleElements.add(RbelHtmlRenderer.showContentButtonAndDialog(element, renderingToolkit));
        if (!renderingToolkit.shouldRenderEntitiesWithSize(element.getSize())) {
            messageTitleElements.add(RENDER_FULLY_BUTTON);
        }
        partnerMessage.map(RbelMessageRenderer::showPartnerMessageButton).ifPresent(messageTitleElements::add);
        messageTitleElements.add(this.showMessageInfos(element, renderingToolkit, messageInfoFacet));
        messageTitleElements.addAll(RbelHtmlRenderingToolkit.addNotes(element, new String[0]));
        List<Object> messageBodyElements = new ArrayList<ContainerTag>();
        if (httpMessageFacet.isPresent()) {
            messageBodyElements = this.performRenderingForBody(renderingToolkit, httpMessageFacet, httpRequestFacet);
        } else {
            messageBodyElements.add(((DivTag)TagCreator.div().withClass("container")).with((DomContent)RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)renderingToolkit.convert(element))));
        }
        return RbelHtmlRenderer.collapsibleCard((ContainerTag)((DivTag)TagCreator.div().with(messageTitleElements)).withClass("full-width"), RbelHtmlRenderingToolkit.ancestorTitle().with(messageBodyElements), "msg-card", "mx-3 mt-3", "msg-content " + (showExpanded ? "" : "d-none"));
    }

    private static DomContent showPartnerMessageButton(RbelElement msg) {
        return TagCreator.span().with((DomContent)((ATag)((ATag)TagCreator.a().withClass("btn modal-button modal-button-details float-end partner-message-button")).attr("onclick", (Object)("scrollToMessage('" + msg.getUuid() + "'," + msg.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).map(Object::toString).orElse("null") + ")"))).with((DomContent)((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)TagCreator.i().withClass("fas fa-right-left"))));
    }

    private DomContent showMessageInfos(RbelElement element, RbelHtmlRenderingToolkit renderingToolkit, Optional<RbelMessageInfoFacet> messageInfoFacet) {
        return ((H1Tag)TagCreator.h1((DomContent[])new DomContent[]{renderingToolkit.constructMessageId(element), this.constructMessageSymbol(element), (DomContent)messageInfoFacet.map(facet -> (SpanTag)TagCreator.span((String)facet.getMenuInfoString()).withClass("font-monospace title ms-3 ")).orElse(TagCreator.span((String)"")), ((SpanTag)TagCreator.span().with(new DomContent[]{RbelMessageRenderer.buildTimingInfo(element), RbelMessageRenderer.buildAddressInfo(element)})).withStyle("display: block;")}).withClasses(new String[]{"title", "ms-3", "text-ellipsis", messageInfoFacet.map(RbelMessageInfoFacet::getColor).orElse("")})).withStyle("overflow: hidden;");
    }

    public static DomContent showBodyToggleButton(boolean showExpanded, String toggleClass, Optional<RbelMessageInfoFacet> messageInfoFacet) {
        return TagCreator.i().withClasses(new String[]{"fa-solid toggle-icon float-end me-3 is-size-3 ms-auto", toggleClass, messageInfoFacet.map(RbelMessageInfoFacet::getColor).orElse(""), showExpanded ? "fa-toggle-on" : "fa-toggle-off"});
    }

    private Optional<RbelElement> findPartner(RbelElement element) {
        return element.getFacet(TracingMessagePairFacet.class).flatMap(msg -> msg.getOtherMessage(element));
    }

    private List<DomContent> performRenderingForBody(RbelHtmlRenderingToolkit renderingToolkit, Optional<RbelHttpMessageFacet> httpMessageFacet, Optional<RbelHttpRequestFacet> httpRequestFacet) {
        ArrayList<Tag> headerTitleElements = new ArrayList<Tag>();
        headerTitleElements.add(TagCreator.i().withClasses(new String[]{"fa-solid fa-toggle-on toggle-icon float-end me-3 is-size-3 text-danger header-toggle"}));
        httpMessageFacet.ifPresent(facet -> headerTitleElements.add((Tag)RbelHtmlRenderer.showContentButtonAndDialog(facet.getHeader(), renderingToolkit)));
        headerTitleElements.add(TagCreator.div((DomContent[])new DomContent[]{(DomContent)httpRequestFacet.map(f -> RbelHtmlRenderingToolkit.t2("REQ Headers")).orElseGet(() -> RbelHtmlRenderingToolkit.t2("RES Headers"))}).withClass("text-danger"));
        ArrayList<Tag> bodyTitleElements = new ArrayList<Tag>();
        bodyTitleElements.add(TagCreator.i().withClasses(new String[]{"fa-solid fa-toggle-on toggle-icon float-end me-3 is-size-3 text-info body-toggle"}));
        httpMessageFacet.ifPresent(facet -> bodyTitleElements.add((Tag)RbelHtmlRenderer.showContentButtonAndDialog(facet.getBody(), renderingToolkit)));
        String bodyTitleString = httpRequestFacet.map(f -> "REQ Body").orElse("RES Body");
        bodyTitleElements.add(TagCreator.div((DomContent[])new DomContent[]{RbelHtmlRenderingToolkit.t2(bodyTitleString)}).withClass("text-info"));
        ArrayList<DomContent> messageBodyElements = new ArrayList<DomContent>();
        messageBodyElements.add((DomContent)RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)((DivTag)TagCreator.div().withClass("tile is-parent is-vertical pe-3")).with(new DomContent[]{TagCreator.div().with((DomContent)RbelHtmlRenderer.collapsibleCard(((DivTag)TagCreator.div().withClass("tile is-child pe-3")).with(headerTitleElements), httpMessageFacet.map(facet -> renderingToolkit.convert(facet.getHeader(), Optional.empty())).orElse((ContainerTag)TagCreator.div()), "is-primary notification", "my-3", "msg-header-content test-msg-header-content")), (DomContent)httpMessageFacet.map(RbelHttpMessageFacet::getBody).map(RbelElement::getRawStringContent).map(s -> StringUtils.isBlank((CharSequence)s) ? (DivTag)((DivTag)TagCreator.div().withClass("is-info notification container is-child")).with((DomContent)RbelHtmlRenderingToolkit.t2(bodyTitleString + " Empty")) : (DivTag)TagCreator.div().with((DomContent)RbelHtmlRenderer.collapsibleCard(((DivTag)TagCreator.div().withClass("tile is-child pe-3")).with((Iterable)bodyTitleElements), renderingToolkit.convert(((RbelHttpMessageFacet)httpMessageFacet.get()).getBody(), Optional.empty()), "is-info notification", "my-3", "msg-body-content test-msg-body-content"))).orElse(TagCreator.div())})));
        return messageBodyElements;
    }

    private DomContent constructMessageSymbol(RbelElement message) {
        return (DomContent)message.getFacet(RbelMessageInfoFacet.class).map(f -> (ContainerTag)((ITag)TagCreator.i().withClass("fas me-1 " + f.getSymbol() + " " + f.getColor())).withTitle(f.getTitle())).orElse((ContainerTag)TagCreator.span());
    }
}

