/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelMessageInfoFacet;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.facets.timing.RbelMessageTimingFacet;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetaDataDto {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageMetaDataDto.class);
    private String uuid;
    private String menuInfoString;
    private List<String> additionalInformation;
    private String recipient;
    private String sender;
    private String bundledServerNameSender;
    private String bundledServerNameReceiver;
    private long sequenceNumber;
    private ZonedDateTime timestamp;
    private boolean isRequest;
    private String pairedUuid;
    private String color;
    private String symbol;
    private String abbrev;
    private boolean removed;

    public static MessageMetaDataDto createFrom(RbelElement el) {
        MessageMetaDataDtoBuilder builder = MessageMetaDataDto.builder();
        builder = builder.uuid(el.getUuid()).sequenceNumber(MessageMetaDataDto.getElementSequenceNumber(el)).sender(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).filter(element -> element.getRawStringContent() != null).flatMap(element -> Optional.of(element.getRawStringContent())).orElse("")).recipient(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).filter(element -> element.getRawStringContent() != null).flatMap(element -> Optional.of(element.getRawStringContent())).orElse("")).bundledServerNameSender(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).flatMap(e -> e.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toRbelSocketAddress).map(RbelSocketAddress::printHostname).filter(s -> !s.startsWith("localhost") && !s.startsWith("127.0.0.1")).or(() -> el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSender).flatMap(e -> e.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).map(s -> s.replace(":", "#58;"))).orElse("")).bundledServerNameReceiver(el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).flatMap(e -> e.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toRbelSocketAddress).map(RbelSocketAddress::printHostname).filter(s -> !s.startsWith("localhost") && !s.startsWith("127.0.0.1")).or(() -> el.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getReceiver).flatMap(e -> e.getFacet(RbelHostnameFacet.class)).map(RbelHostnameFacet::toString).map(s -> s.replace(":", "#58;"))).orElse("")).pairedUuid(el.getFacet(TracingMessagePairFacet.class).flatMap(f -> f.getOtherMessage(el)).map(RbelElement::getUuid).orElse(null));
        builder.additionalInformation(el.findAllNestedFacets(RbelMessageInfoFacet.class).stream().map(RbelMessageInfoFacet::getMenuInfoString).toList());
        builder.menuInfoString(el.getFacet(RbelMessageInfoFacet.class).map(RbelMessageInfoFacet::getMenuInfoString).orElse("<noMenuInfoString>"));
        builder.symbol(el.getFacet(RbelMessageInfoFacet.class).map(RbelMessageInfoFacet::getSymbol).orElse("<noSymbol>"));
        builder.abbrev(el.getFacet(RbelMessageInfoFacet.class).map(RbelMessageInfoFacet::getAbbrev).orElse("<noAbbrev>"));
        builder.color(el.getFacet(RbelMessageInfoFacet.class).map(RbelMessageInfoFacet::getColor).orElse("<noColor>"));
        builder.isRequest(el.hasFacet(RbelRequestFacet.class));
        builder.timestamp(el.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null));
        return builder.build();
    }

    public static long getElementSequenceNumber(RbelElement rbelElement) {
        return rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(RbelTcpIpMessageFacet::getSequenceNumber).orElse(0L);
    }

    @Generated
    private static List<String> $default$additionalInformation() {
        return new ArrayList<String>();
    }

    @Generated
    public static MessageMetaDataDtoBuilder builder() {
        return new MessageMetaDataDtoBuilder();
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getMenuInfoString() {
        return this.menuInfoString;
    }

    @Generated
    public List<String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    @Generated
    public String getRecipient() {
        return this.recipient;
    }

    @Generated
    public String getSender() {
        return this.sender;
    }

    @Generated
    public String getBundledServerNameSender() {
        return this.bundledServerNameSender;
    }

    @Generated
    public String getBundledServerNameReceiver() {
        return this.bundledServerNameReceiver;
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean isRequest() {
        return this.isRequest;
    }

    @Generated
    public String getPairedUuid() {
        return this.pairedUuid;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public String getSymbol() {
        return this.symbol;
    }

    @Generated
    public String getAbbrev() {
        return this.abbrev;
    }

    @Generated
    public boolean isRemoved() {
        return this.removed;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMenuInfoString(String menuInfoString) {
        this.menuInfoString = menuInfoString;
    }

    @Generated
    public void setAdditionalInformation(List<String> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    @Generated
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Generated
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Generated
    public void setBundledServerNameSender(String bundledServerNameSender) {
        this.bundledServerNameSender = bundledServerNameSender;
    }

    @Generated
    public void setBundledServerNameReceiver(String bundledServerNameReceiver) {
        this.bundledServerNameReceiver = bundledServerNameReceiver;
    }

    @Generated
    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Generated
    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setRequest(boolean isRequest) {
        this.isRequest = isRequest;
    }

    @Generated
    public void setPairedUuid(String pairedUuid) {
        this.pairedUuid = pairedUuid;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @Generated
    public void setAbbrev(String abbrev) {
        this.abbrev = abbrev;
    }

    @Generated
    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageMetaDataDto)) {
            return false;
        }
        MessageMetaDataDto other = (MessageMetaDataDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        if (this.isRequest() != other.isRequest()) {
            return false;
        }
        if (this.isRemoved() != other.isRemoved()) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$menuInfoString = this.getMenuInfoString();
        String other$menuInfoString = other.getMenuInfoString();
        if (this$menuInfoString == null ? other$menuInfoString != null : !this$menuInfoString.equals(other$menuInfoString)) {
            return false;
        }
        List<String> this$additionalInformation = this.getAdditionalInformation();
        List<String> other$additionalInformation = other.getAdditionalInformation();
        if (this$additionalInformation == null ? other$additionalInformation != null : !((Object)this$additionalInformation).equals(other$additionalInformation)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$bundledServerNameSender = this.getBundledServerNameSender();
        String other$bundledServerNameSender = other.getBundledServerNameSender();
        if (this$bundledServerNameSender == null ? other$bundledServerNameSender != null : !this$bundledServerNameSender.equals(other$bundledServerNameSender)) {
            return false;
        }
        String this$bundledServerNameReceiver = this.getBundledServerNameReceiver();
        String other$bundledServerNameReceiver = other.getBundledServerNameReceiver();
        if (this$bundledServerNameReceiver == null ? other$bundledServerNameReceiver != null : !this$bundledServerNameReceiver.equals(other$bundledServerNameReceiver)) {
            return false;
        }
        ZonedDateTime this$timestamp = this.getTimestamp();
        ZonedDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$pairedUuid = this.getPairedUuid();
        String other$pairedUuid = other.getPairedUuid();
        if (this$pairedUuid == null ? other$pairedUuid != null : !this$pairedUuid.equals(other$pairedUuid)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$abbrev = this.getAbbrev();
        String other$abbrev = other.getAbbrev();
        return !(this$abbrev == null ? other$abbrev != null : !this$abbrev.equals(other$abbrev));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageMetaDataDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        result = result * 59 + (this.isRequest() ? 79 : 97);
        result = result * 59 + (this.isRemoved() ? 79 : 97);
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $menuInfoString = this.getMenuInfoString();
        result = result * 59 + ($menuInfoString == null ? 43 : $menuInfoString.hashCode());
        List<String> $additionalInformation = this.getAdditionalInformation();
        result = result * 59 + ($additionalInformation == null ? 43 : ((Object)$additionalInformation).hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $bundledServerNameSender = this.getBundledServerNameSender();
        result = result * 59 + ($bundledServerNameSender == null ? 43 : $bundledServerNameSender.hashCode());
        String $bundledServerNameReceiver = this.getBundledServerNameReceiver();
        result = result * 59 + ($bundledServerNameReceiver == null ? 43 : $bundledServerNameReceiver.hashCode());
        ZonedDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $pairedUuid = this.getPairedUuid();
        result = result * 59 + ($pairedUuid == null ? 43 : $pairedUuid.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $abbrev = this.getAbbrev();
        result = result * 59 + ($abbrev == null ? 43 : $abbrev.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageMetaDataDto(uuid=" + this.getUuid() + ", menuInfoString=" + this.getMenuInfoString() + ", additionalInformation=" + String.valueOf(this.getAdditionalInformation()) + ", recipient=" + this.getRecipient() + ", sender=" + this.getSender() + ", bundledServerNameSender=" + this.getBundledServerNameSender() + ", bundledServerNameReceiver=" + this.getBundledServerNameReceiver() + ", sequenceNumber=" + this.getSequenceNumber() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", isRequest=" + this.isRequest() + ", pairedUuid=" + this.getPairedUuid() + ", color=" + this.getColor() + ", symbol=" + this.getSymbol() + ", abbrev=" + this.getAbbrev() + ", removed=" + this.isRemoved() + ")";
    }

    @ConstructorProperties(value={"uuid", "menuInfoString", "additionalInformation", "recipient", "sender", "bundledServerNameSender", "bundledServerNameReceiver", "sequenceNumber", "timestamp", "isRequest", "pairedUuid", "color", "symbol", "abbrev", "removed"})
    @Generated
    public MessageMetaDataDto(String uuid, String menuInfoString, List<String> additionalInformation, String recipient, String sender, String bundledServerNameSender, String bundledServerNameReceiver, long sequenceNumber, ZonedDateTime timestamp, boolean isRequest, String pairedUuid, String color, String symbol, String abbrev, boolean removed) {
        this.uuid = uuid;
        this.menuInfoString = menuInfoString;
        this.additionalInformation = additionalInformation;
        this.recipient = recipient;
        this.sender = sender;
        this.bundledServerNameSender = bundledServerNameSender;
        this.bundledServerNameReceiver = bundledServerNameReceiver;
        this.sequenceNumber = sequenceNumber;
        this.timestamp = timestamp;
        this.isRequest = isRequest;
        this.pairedUuid = pairedUuid;
        this.color = color;
        this.symbol = symbol;
        this.abbrev = abbrev;
        this.removed = removed;
    }

    @Generated
    public MessageMetaDataDto() {
        this.additionalInformation = MessageMetaDataDto.$default$additionalInformation();
    }

    @Generated
    public static class MessageMetaDataDtoBuilder {
        @Generated
        private String uuid;
        @Generated
        private String menuInfoString;
        @Generated
        private boolean additionalInformation$set;
        @Generated
        private List<String> additionalInformation$value;
        @Generated
        private String recipient;
        @Generated
        private String sender;
        @Generated
        private String bundledServerNameSender;
        @Generated
        private String bundledServerNameReceiver;
        @Generated
        private long sequenceNumber;
        @Generated
        private ZonedDateTime timestamp;
        @Generated
        private boolean isRequest;
        @Generated
        private String pairedUuid;
        @Generated
        private String color;
        @Generated
        private String symbol;
        @Generated
        private String abbrev;
        @Generated
        private boolean removed;

        @Generated
        MessageMetaDataDtoBuilder() {
        }

        @Generated
        public MessageMetaDataDtoBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder menuInfoString(String menuInfoString) {
            this.menuInfoString = menuInfoString;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder additionalInformation(List<String> additionalInformation) {
            this.additionalInformation$value = additionalInformation;
            this.additionalInformation$set = true;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder recipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder sender(String sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder bundledServerNameSender(String bundledServerNameSender) {
            this.bundledServerNameSender = bundledServerNameSender;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder bundledServerNameReceiver(String bundledServerNameReceiver) {
            this.bundledServerNameReceiver = bundledServerNameReceiver;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder isRequest(boolean isRequest) {
            this.isRequest = isRequest;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder pairedUuid(String pairedUuid) {
            this.pairedUuid = pairedUuid;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder color(String color) {
            this.color = color;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder abbrev(String abbrev) {
            this.abbrev = abbrev;
            return this;
        }

        @Generated
        public MessageMetaDataDtoBuilder removed(boolean removed) {
            this.removed = removed;
            return this;
        }

        @Generated
        public MessageMetaDataDto build() {
            List<String> additionalInformation$value = this.additionalInformation$value;
            if (!this.additionalInformation$set) {
                additionalInformation$value = MessageMetaDataDto.$default$additionalInformation();
            }
            return new MessageMetaDataDto(this.uuid, this.menuInfoString, additionalInformation$value, this.recipient, this.sender, this.bundledServerNameSender, this.bundledServerNameReceiver, this.sequenceNumber, this.timestamp, this.isRequest, this.pairedUuid, this.color, this.symbol, this.abbrev, this.removed);
        }

        @Generated
        public String toString() {
            return "MessageMetaDataDto.MessageMetaDataDtoBuilder(uuid=" + this.uuid + ", menuInfoString=" + this.menuInfoString + ", additionalInformation$value=" + String.valueOf(this.additionalInformation$value) + ", recipient=" + this.recipient + ", sender=" + this.sender + ", bundledServerNameSender=" + this.bundledServerNameSender + ", bundledServerNameReceiver=" + this.bundledServerNameReceiver + ", sequenceNumber=" + this.sequenceNumber + ", timestamp=" + String.valueOf(this.timestamp) + ", isRequest=" + this.isRequest + ", pairedUuid=" + this.pairedUuid + ", color=" + this.color + ", symbol=" + this.symbol + ", abbrev=" + this.abbrev + ", removed=" + this.removed + ")";
        }
    }
}

