/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import com.fasterxml.jackson.databind.JsonNode;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.exceptions.RbelJexlException;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;

public class RbelJsonWriter
implements RbelElementWriter {
    @Override
    public boolean canWrite(RbelElement oldTargetElement) {
        return oldTargetElement.hasFacet(RbelJsonFacet.class);
    }

    @Override
    public byte[] write(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, byte[] newContent) {
        JsonNode jsonElement = oldTargetElement.getFacetOrFail(RbelJsonFacet.class).getJsonElement();
        if (jsonElement.isValueNode()) {
            if (jsonElement.isTextual()) {
                return this.quote(new String(newContent, oldTargetElement.getElementCharset())).getBytes(oldTargetElement.getElementCharset());
            }
            return newContent;
        }
        if (jsonElement.isObject()) {
            return this.writeJsonObject(oldTargetElement, oldTargetModifiedChild, newContent, jsonElement);
        }
        if (jsonElement.isArray()) {
            StringJoiner joiner = new StringJoiner(",");
            Iterator it = jsonElement.elements();
            while (it.hasNext()) {
                JsonNode entry = (JsonNode)it.next();
                if (entry == oldTargetModifiedChild.getFacetOrFail(RbelJsonFacet.class).getJsonElement()) {
                    joiner.add(new String(newContent, oldTargetElement.getElementCharset()));
                    continue;
                }
                joiner.add(entry.toString());
            }
            return ("[" + String.valueOf(joiner) + "]").getBytes(oldTargetElement.getElementCharset());
        }
        throw new RbelJexlException("Unable to write element that has no Json facet: " + oldTargetElement.printTreeStructure());
    }

    private byte[] writeJsonObject(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, byte[] newContent, JsonNode jsonElement) {
        StringJoiner joiner = new StringJoiner(",");
        Iterator it = jsonElement.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (entry.getValue() == oldTargetModifiedChild.getFacetOrFail(RbelJsonFacet.class).getJsonElement()) {
                joiner.add(this.quote((String)entry.getKey()) + ": " + new String(newContent, oldTargetElement.getElementCharset()));
                continue;
            }
            joiner.add(this.quote((String)entry.getKey()) + ": " + ((JsonNode)entry.getValue()).toString());
        }
        return ("{" + String.valueOf(joiner) + "}").getBytes(oldTargetElement.getElementCharset());
    }

    private String quote(String str) {
        return "\"" + str + "\"";
    }
}

