/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.key;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelNestedFacet;
import de.gematik.rbellogger.facets.jackson.RbelJsonConverter;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.facets.jose.RbelJweConverter;
import de.gematik.rbellogger.facets.jose.RbelJwtConverter;
import de.gematik.rbellogger.key.RbelKey;
import java.security.Key;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelKeyManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelKeyManager.class);
    private final List<RbelKey> keyList = new ArrayList<RbelKey>();
    private final Set<RbelKey> keySet = new HashSet<RbelKey>();

    public synchronized RbelKeyManager addAll(Map<String, RbelKey> keys) {
        this.keyList.addAll(keys.values());
        return this;
    }

    public synchronized Optional<RbelKey> addKey(RbelKey rbelKey) {
        if (rbelKey.getKey() == null) {
            return Optional.empty();
        }
        if (this.keyIsPresentInList(rbelKey)) {
            log.trace("Skipping adding key: Key is already known!");
            return Optional.empty();
        }
        this.keyList.add(rbelKey);
        this.keySet.add(rbelKey);
        log.debug("Added key {} (Now there are {} keys known)", (Object)rbelKey.getKeyName(), (Object)this.keyList.size());
        return Optional.of(rbelKey);
    }

    public synchronized Optional<RbelKey> addKey(String keyId, Key key, int precedence) {
        RbelKey rbelKey = RbelKey.builder().keyName(keyId).key(key).precedence(precedence).build();
        return this.addKey(rbelKey);
    }

    private synchronized boolean keyIsPresentInList(RbelKey key) {
        log.atTrace().addArgument(() -> Hex.toHexString((byte[])key.getHash())).log("Checking if key is already known: {}");
        return this.keyList.stream().anyMatch(oldKey -> oldKey.equals(key));
    }

    public synchronized Stream<RbelKey> getAllKeys() {
        return new ArrayList<RbelKey>(this.keyList).stream().sorted(Comparator.comparing(RbelKey::getPrecedence));
    }

    public synchronized Optional<RbelKey> findCorrespondingPrivateKey(String rbelKey) {
        return this.getAllKeys().filter(candidate -> candidate.getMatchingPublicKey().isPresent()).filter(candidate -> Objects.equals(candidate.getMatchingPublicKey().get().getKeyName(), rbelKey)).findFirst();
    }

    public synchronized Optional<RbelKey> findKeyByName(String keyName) {
        return this.getAllKeys().filter(candidate -> candidate.getKeyName() != null && candidate.getKeyName().equals(keyName)).findFirst();
    }

    @ConverterInfo(dependsOn={RbelJwtConverter.class, RbelJsonConverter.class, RbelJweConverter.class})
    public static class RbelIdpTokenKeyListener
    extends RbelConverterPlugin {
        @Override
        public void consumeElement(RbelElement element, RbelConversionExecutor converter) {
            Optional.ofNullable(element).filter(el -> el.hasFacet(RbelJsonFacet.class)).flatMap(el -> el.getFirst("token_key")).flatMap(el -> el.getFacet(RbelNestedFacet.class)).map(RbelNestedFacet::getNestedElement).map(RbelElement::getRawStringContent).map(tokenB64 -> {
                try {
                    return Base64.getUrlDecoder().decode((String)tokenB64);
                }
                catch (Exception e1) {
                    try {
                        return Base64.getDecoder().decode((String)tokenB64);
                    }
                    catch (Exception e2) {
                        return null;
                    }
                }
            }).map(tokenKeyBytes -> new SecretKeySpec((byte[])tokenKeyBytes, "AES")).ifPresent(aesKey -> converter.getRbelKeyManager().addKey("token_key", (Key)aesKey, 110));
        }
    }
}

