/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.key;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;

public class RbelKey {
    public static final int PRECEDENCE_X5C_HEADER_VALUE = 100;
    public static final int PRECEDENCE_KEY_FOLDER = 110;
    public static final int PRECEDENCE_JWK_VALUE = 200;
    private final Key key;
    private final String keyName;
    private final byte[] hash;
    private final int precedence;
    private final Optional<RbelKey> matchingPublicKey;

    public RbelKey(Key key, String keyName, int precedence, RbelKey matchingPublicKey) {
        this.key = key;
        this.keyName = keyName;
        this.precedence = precedence;
        this.hash = DigestUtils.sha256((byte[])key.getEncoded());
        this.matchingPublicKey = Optional.ofNullable(matchingPublicKey);
    }

    public RbelKey(Key key, String keyName, int precedence) {
        this.key = key;
        this.keyName = keyName;
        this.precedence = precedence;
        this.hash = DigestUtils.sha256((byte[])key.getEncoded());
        this.matchingPublicKey = Optional.empty();
    }

    public RbelKey(Key key, String keyName, int precedence, Optional<RbelKey> matchingPublicKey) {
        this.key = key;
        this.keyName = keyName;
        this.precedence = precedence;
        this.hash = DigestUtils.sha256((byte[])key.getEncoded());
        this.matchingPublicKey = matchingPublicKey;
    }

    public Optional<KeyPair> retrieveCorrespondingKeyPair() {
        if (this.key instanceof PrivateKey) {
            return this.matchingPublicKey.map(RbelKey::getKey).filter(PublicKey.class::isInstance).map(PublicKey.class::cast).map(pubKey -> new KeyPair((PublicKey)pubKey, (PrivateKey)this.key));
        }
        return Optional.empty();
    }

    public boolean isPrivateKey() {
        return this.getKey() instanceof PrivateKey;
    }

    @Generated
    public static RbelKeyBuilder builder() {
        return new RbelKeyBuilder();
    }

    @Generated
    public Key getKey() {
        return this.key;
    }

    @Generated
    public String getKeyName() {
        return this.keyName;
    }

    @Generated
    public byte[] getHash() {
        return this.hash;
    }

    @Generated
    public int getPrecedence() {
        return this.precedence;
    }

    @Generated
    public Optional<RbelKey> getMatchingPublicKey() {
        return this.matchingPublicKey;
    }

    @Generated
    public String toString() {
        return "RbelKey(key=" + String.valueOf(this.getKey()) + ", keyName=" + this.getKeyName() + ", hash=" + Arrays.toString(this.getHash()) + ", precedence=" + this.getPrecedence() + ", matchingPublicKey=" + String.valueOf(this.getMatchingPublicKey()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelKey)) {
            return false;
        }
        RbelKey other = (RbelKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getHash(), other.getHash());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getHash());
        return result;
    }

    @Generated
    public static class RbelKeyBuilder {
        @Generated
        private Key key;
        @Generated
        private String keyName;
        @Generated
        private int precedence;
        @Generated
        private RbelKey matchingPublicKey;

        @Generated
        RbelKeyBuilder() {
        }

        @Generated
        public RbelKeyBuilder key(Key key) {
            this.key = key;
            return this;
        }

        @Generated
        public RbelKeyBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Generated
        public RbelKeyBuilder precedence(int precedence) {
            this.precedence = precedence;
            return this;
        }

        @Generated
        public RbelKeyBuilder matchingPublicKey(RbelKey matchingPublicKey) {
            this.matchingPublicKey = matchingPublicKey;
            return this;
        }

        @Generated
        public RbelKey build() {
            return new RbelKey(this.key, this.keyName, this.precedence, this.matchingPublicKey);
        }

        @Generated
        public String toString() {
            return "RbelKey.RbelKeyBuilder(key=" + String.valueOf(this.key) + ", keyName=" + this.keyName + ", precedence=" + this.precedence + ", matchingPublicKey=" + String.valueOf(this.matchingPublicKey) + ")";
        }
    }
}

