/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.initializers;

import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.exceptions.RbelPkiException;
import de.gematik.rbellogger.key.IdentityBackedRbelKey;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityLoader;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;

public class RbelKeyFolderInitializer
implements Consumer<RbelConverter> {
    private final String keyFolderPath;

    @Override
    public void accept(RbelConverter rbelConverter) {
        AtomicReference currentFile = new AtomicReference();
        try (Stream<Path> fileStream = Files.walk(Path.of(this.keyFolderPath, new String[0]), new FileVisitOption[0]);){
            fileStream.map(path -> this.setCurrentFile((Path)path, currentFile)).map(Path::toFile).filter(File::isFile).filter(File::canRead).filter(file -> file.getName().endsWith(".p12")).map(file -> TigerPkiIdentityLoader.loadRbelPkiIdentityWithGuessedPassword((File)file).withKeyId(Optional.ofNullable(file.getName().split("\\.")[0]))).map(IdentityBackedRbelKey::generateRbelKeyPairForIdentity).flatMap(Collection::stream).forEach(rbelConverter.getRbelKeyManager()::addKey);
        }
        catch (IOException e) {
            throw new RbelPkiException("Error while initializing keys, failed at file '" + String.valueOf(((Path)currentFile.get()).toAbsolutePath()) + "'", e);
        }
    }

    private Path setCurrentFile(Path path, AtomicReference<Path> currentFile) {
        currentFile.set(path);
        return path;
    }

    @ConstructorProperties(value={"keyFolderPath"})
    @Generated
    public RbelKeyFolderInitializer(String keyFolderPath) {
        this.keyFolderPath = keyFolderPath;
    }
}

