/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.file;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverter;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.data.facet.RbelNonTransmissionMarkerFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.file.ProxyFileReadingFilter;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.exceptions.GenericTigerException;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelFileWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelFileWriter.class);
    private static final String FILE_DIVIDER = "\n";
    public static final String RAW_MESSAGE_CONTENT = "rawMessageContent";
    public static final String SEQUENCE_NUMBER = "sequenceNumber";
    public static final String MESSAGE_TIME = "timestamp";
    public static final String MESSAGE_UUID = "uuid";
    private final RbelConverter rbelConverter;

    public String convertToRbelFileString(RbelElement rbelElement) {
        return this.convertToRbelFileString(rbelElement, Long.MAX_VALUE);
    }

    public String convertToRbelFileString(RbelElement rbelElement, long skipContentThreshold) {
        JSONObject jsonObject = new JSONObject(Map.of(MESSAGE_UUID, rbelElement.getUuid()));
        if (rbelElement.getSize() <= skipContentThreshold) {
            jsonObject.put(RAW_MESSAGE_CONTENT, (Object)this.encodeToBase64(rbelElement.getContent()));
        }
        rbelElement.getFacet(RbelMessageMetadata.class).ifPresent(metadata -> metadata.forEach((arg_0, arg_1) -> ((JSONObject)jsonObject).put(arg_0, arg_1)));
        return String.valueOf(jsonObject) + FILE_DIVIDER;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String encodeToBase64(RbelContent content) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            block20: {
                InputStream in = content.toInputStream();
                try {
                    try (OutputStream encoding = Base64.getEncoder().wrap(out);){
                        in.transferTo(encoding);
                    }
                    string = out.toString();
                    if (in == null) break block20;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
    }

    public List<RbelElement> convertFromRbelFile(String rbelFileContent, Optional<String> readFilter) {
        return this.convertRbelFileEntries(rbelFileContent.lines(), readFilter, null);
    }

    public List<RbelElement> convertRbelFileEntries(Stream<String> rbelFileLines, Optional<String> readFilter, Function<String, RbelContent> contentProvider) {
        List<String> rawMessageStrings = rbelFileLines.filter(StringUtils::isNotBlank).toList();
        log.info("Found {} messages in file, starting parsing...", (Object)rawMessageStrings.size());
        AtomicInteger numberOfParsedMessages = new AtomicInteger(0);
        List<RbelElement> list = rawMessageStrings.stream().peek(str -> {
            if (numberOfParsedMessages.get() > 0 && numberOfParsedMessages.getAndIncrement() % 500 == 0) {
                log.info("Parsed {} messages, continuing...", (Object)numberOfParsedMessages);
            }
        }).map(JSONObject::new).sorted(Comparator.comparing(json -> json.optInt(SEQUENCE_NUMBER, Integer.MAX_VALUE))).map(messageObject -> this.parseFileObject((JSONObject)messageObject, readFilter, contentProvider)).filter(Optional::isPresent).map(Optional::get).toList();
        log.info("Parsing complete, parsed {} messages of {} available", (Object)list.size(), (Object)rawMessageStrings.size());
        return list;
    }

    private Optional<RbelElement> parseFileObject(JSONObject messageObject, Optional<String> readFilter, Function<String, RbelContent> contentProvider) {
        try {
            String msgUuid = messageObject.optString(MESSAGE_UUID);
            if (this.rbelConverter.getKnownMessageUuids().add(msgUuid)) {
                return this.getContent(messageObject, msgUuid, contentProvider).map(content -> this.parseContent((RbelContent)content, messageObject, readFilter, msgUuid));
            }
            log.atDebug().log("Skipping conversion for already known message uuid: {}", (Object)msgUuid);
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RbelFileReadingException("Error while converting from object '" + messageObject.toString() + "'", e);
        }
    }

    private Optional<RbelContent> getContent(JSONObject messageObject, String msgUuid, Function<String, RbelContent> contentProvider) throws IOException {
        if (!messageObject.has(RAW_MESSAGE_CONTENT)) {
            if (contentProvider == null) {
                log.warn("No message content provider found for message uuid: {}", (Object)msgUuid);
                return Optional.empty();
            }
            try {
                RbelContent content = contentProvider.apply(msgUuid);
                if (content == null) {
                    log.warn("No content found for message uuid: {}", (Object)msgUuid);
                    return Optional.empty();
                }
                return Optional.of(content);
            }
            catch (Exception e) {
                log.error("Error while reading content for message uuid: {}", (Object)msgUuid, (Object)e);
                return Optional.empty();
            }
        }
        return Optional.of(RbelContent.from(Base64.getDecoder().wrap((InputStream)((ReaderInputStream.Builder)ReaderInputStream.builder().setReader((Reader)new StringReader(messageObject.getString(RAW_MESSAGE_CONTENT)))).get())));
    }

    private RbelElement parseContent(RbelContent content, JSONObject messageObject, Optional<String> readFilter, String msgUuid) {
        RbelElement rawMessageObject = RbelElement.builder().content(content).uuid(msgUuid).parentNode(null).build();
        rawMessageObject.addFacet(new IncompleteMessageReadFromFile());
        readFilter.ifPresent(filterCriterion -> rawMessageObject.addFacet(new ProxyFileReadingFilter.TgrFileFilterFacet((String)filterCriterion)));
        RbelMessageMetadata messageMetadata = new RbelMessageMetadata();
        this.enrichMetadataFromJson(messageMetadata, messageObject);
        RbelElement parsedMessage = this.rbelConverter.parseMessage(rawMessageObject, messageMetadata);
        parsedMessage.removeFacetsOfType(IncompleteMessageReadFromFile.class);
        return parsedMessage;
    }

    private void enrichMetadataFromJson(RbelMessageMetadata messageMetadata, JSONObject messageObject) {
        for (String key : messageObject.keySet()) {
            messageMetadata.addMetadata(key, messageObject.get(key));
        }
    }

    @ConstructorProperties(value={"rbelConverter"})
    @Generated
    public RbelFileWriter(RbelConverter rbelConverter) {
        this.rbelConverter = rbelConverter;
    }

    private static class RbelFileReadingException
    extends GenericTigerException {
        public RbelFileReadingException(String s, Exception e) {
            super(s, (Throwable)e);
        }
    }

    public static class IncompleteMessageReadFromFile
    implements RbelFacet {
    }

    public static class TgrFilePairingWriterPlugin
    extends RbelConverterPlugin {
        @Override
        public RbelConversionPhase getPhase() {
            return RbelConversionPhase.TRANSMISSION;
        }

        @Override
        public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
            Optional<RbelMessageMetadata> metadataFacet = rbelElement.getFacet(RbelMessageMetadata.class);
            if (metadataFacet.isEmpty() || rbelElement.hasFacet(RbelNonTransmissionMarkerFacet.class)) {
                return;
            }
            rbelElement.getFacet(TracingMessagePairFacet.class).flatMap(facet -> facet.getOtherMessage(rbelElement)).map(RbelElement::getUuid).ifPresent(uuid -> RbelMessageMetadata.PAIRED_MESSAGE_UUID.putValue((RbelMessageMetadata)metadataFacet.get(), (String)uuid));
        }
    }

    public static class TgrFilePairingPlugin
    extends RbelConverterPlugin {
        @Override
        public RbelConversionPhase getPhase() {
            return RbelConversionPhase.PREPARATION;
        }

        @Override
        public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
            Optional<RbelMessageMetadata> metadataFacet = rbelElement.getFacet(RbelMessageMetadata.class);
            if (metadataFacet.isEmpty() || !rbelElement.hasFacet(IncompleteMessageReadFromFile.class)) {
                return;
            }
            Optional<String> value = RbelMessageMetadata.PAIRED_MESSAGE_UUID.getValue(metadataFacet.get());
            if (value.isPresent()) {
                converter.findMessageByUuid(value.get()).ifPresent(other -> {
                    TracingMessagePairFacet pair = other.hasFacet(RbelRequestFacet.class) ? new TracingMessagePairFacet(rbelElement, (RbelElement)other) : new TracingMessagePairFacet((RbelElement)other, rbelElement);
                    rbelElement.addOrReplaceFacet(pair);
                    other.addOrReplaceFacet(pair);
                });
            } else {
                this.pairPotentialHttpResponseWithPreviousMessage(rbelElement, converter);
            }
        }

        public void pairPotentialHttpResponseWithPreviousMessage(RbelElement message, RbelConversionExecutor converter) {
            if (Optional.ofNullable(message.getRawStringContent()).map(content -> content.startsWith("HTTP/")).orElse(false).booleanValue()) {
                converter.messagesStreamLatestFirst().dropWhile(candidate -> candidate != message).filter(msg -> msg.hasFacet(RbelHttpRequestFacet.class)).filter(msg -> !msg.hasFacet(TracingMessagePairFacet.class)).findFirst().ifPresent(previousMessage -> {
                    message.addOrReplaceFacet(new TracingMessagePairFacet(message, (RbelElement)previousMessage));
                    previousMessage.addOrReplaceFacet(new TracingMessagePairFacet(message, (RbelElement)previousMessage));
                });
            }
        }
    }
}

