/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.file;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFileReadingFilter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyFileReadingFilter.class);
    private final Map<String, RbelElement> deletedMessages = new HashMap<String, RbelElement>();

    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.CONTENT_ENRICHMENT;
    }

    @Override
    public void consumeElement(RbelElement message, RbelConversionExecutor converter) {
        Optional<TgrFileFilterFacet> filterFacet = message.getFacet(TgrFileFilterFacet.class);
        Optional<RbelMessageMetadata> metadataFacet = message.getFacet(RbelMessageMetadata.class);
        if (filterFacet.isEmpty() || metadataFacet.isEmpty()) {
            return;
        }
        Optional<String> pairedUuidOptional = RbelMessageMetadata.PAIRED_MESSAGE_UUID.getValue(metadataFacet.get());
        if (this.isKeepMessage(message, filterFacet.get().filterExpression)) {
            pairedUuidOptional.ifPresent(partnerUuid -> {
                RbelElement deletedPartner = this.deletedMessages.get(partnerUuid);
                if (deletedPartner != null) {
                    this.deletedMessages.remove(deletedPartner.getUuid());
                }
            });
        } else if (pairedUuidOptional.isPresent()) {
            RbelElement partnerMessage = this.deletedMessages.get(pairedUuidOptional.get());
            if (partnerMessage != null) {
                converter.removeMessage(message);
                converter.removeMessage(partnerMessage);
            }
        } else {
            this.deletedMessages.put(message.getUuid(), message);
        }
        message.removeFacetsOfType(TgrFileFilterFacet.class);
    }

    private boolean isKeepMessage(RbelElement message, String filterExpression) {
        if (StringUtils.isEmpty((CharSequence)filterExpression)) {
            return true;
        }
        return TigerJexlExecutor.matchesAsJexlExpression((Object)message, (String)filterExpression);
    }

    @Generated
    public ProxyFileReadingFilter() {
    }

    public static class TgrFileFilterFacet
    implements RbelFacet {
        private final String filterExpression;

        @ConstructorProperties(value={"filterExpression"})
        @Generated
        public TgrFileFilterFacet(String filterExpression) {
            this.filterExpression = filterExpression;
        }
    }
}

