/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.file;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMessageMetadata;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundledServerNameWriterAndReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BundledServerNameWriterAndReader.class);
    public static final RbelMessageMetadata.RbelMetadataValue<String> BUNDLED_HOSTNAME_SENDER = new RbelMessageMetadata.RbelMetadataValue<String>("bundledHostnameSender", String.class);
    public static final RbelMessageMetadata.RbelMetadataValue<String> BUNDLED_HOSTNAME_RECEIVER = new RbelMessageMetadata.RbelMetadataValue<String>("bundledHostnameReceiver", String.class);

    public static class BundledServerNameWriter
    extends RbelConverterPlugin {
        @Override
        public RbelConversionPhase getPhase() {
            return RbelConversionPhase.CONTENT_ENRICHMENT;
        }

        @Override
        public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
            rbelElement.getFacet(RbelMessageMetadata.class).ifPresent(metadata -> {
                BUNDLED_HOSTNAME_SENDER.putValue((RbelMessageMetadata)metadata, BundledServerNameWriter.extractBundledHostname(rbelElement, RbelTcpIpMessageFacet::getSender));
                BUNDLED_HOSTNAME_RECEIVER.putValue((RbelMessageMetadata)metadata, BundledServerNameWriter.extractBundledHostname(rbelElement, RbelTcpIpMessageFacet::getReceiver));
            });
        }

        private static String extractBundledHostname(RbelElement rbelElement, Function<RbelTcpIpMessageFacet, RbelElement> targetExtractor) {
            return rbelElement.getFacet(RbelTcpIpMessageFacet.class).map(targetExtractor).flatMap(el -> el.getFacet(RbelHostnameFacet.class)).flatMap(RbelHostnameFacet::getBundledServerName).map(RbelElement::getRawStringContent).orElse(null);
        }
    }

    public static class BundledServerNameReader
    extends RbelConverterPlugin {
        @Override
        public RbelConversionPhase getPhase() {
            return RbelConversionPhase.PROTOCOL_PARSING;
        }

        @Override
        public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
            rbelElement.getFacet(RbelMessageMetadata.class).ifPresent(metadata -> {
                BUNDLED_HOSTNAME_SENDER.getValue((RbelMessageMetadata)metadata).ifPresent(data -> BundledServerNameReader.performBundledServerNameExtraction(rbelElement, RbelTcpIpMessageFacet::getSender, data));
                BUNDLED_HOSTNAME_RECEIVER.getValue((RbelMessageMetadata)metadata).ifPresent(data -> BundledServerNameReader.performBundledServerNameExtraction(rbelElement, RbelTcpIpMessageFacet::getReceiver, data));
            });
        }

        private static void performBundledServerNameExtraction(RbelElement message, Function<RbelTcpIpMessageFacet, RbelElement> targetExtractor, Object extractedValue) {
            message.getFacet(RbelTcpIpMessageFacet.class).map(targetExtractor).ifPresent(target -> {
                RbelHostnameFacet oldFacet = target.getFacet(RbelHostnameFacet.class).orElse(null);
                if (oldFacet != null) {
                    target.addOrReplaceFacet(RbelHostnameFacet.builder().domain(oldFacet.getDomain()).port(oldFacet.getPort()).bundledServerName(Optional.of(RbelElement.wrap(target, extractedValue))).build());
                }
            });
        }
    }
}

