/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.xml;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelMapFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.http.RbelHttpRequestConverter;
import de.gematik.rbellogger.facets.http.RbelHttpResponseConverter;
import de.gematik.rbellogger.facets.xml.RbelHtmlConverter;
import de.gematik.rbellogger.facets.xml.RbelXmlAttributeFacet;
import de.gematik.rbellogger.facets.xml.RbelXmlFacet;
import de.gematik.rbellogger.facets.xml.RbelXmlNamespaceFacet;
import de.gematik.rbellogger.facets.xml.RbelXmlProcessingInstructionFacet;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.rbellogger.util.RbelException;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultProcessingInstruction;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@ConverterInfo(dependsOn={RbelHttpRequestConverter.class, RbelHttpResponseConverter.class})
public class RbelXmlConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelXmlConverter.class);
    private static final String XML_TEXT_KEY = "text";
    private static final RbelHtmlConverter HTML_CONVERTER = new RbelHtmlConverter();
    private static final byte[] OPEN_TAG = "<".getBytes();
    private static final byte[] CLOSE_TAG = ">".getBytes();

    @Override
    public void consumeElement(RbelElement rbel, RbelConversionExecutor context) {
        RbelContent content = rbel.getContent();
        if (!content.startsTrimmedWith(OPEN_TAG) || !content.endsTrimmedWith(CLOSE_TAG)) {
            return;
        }
        try {
            InputSource source = this.buildInputSource(rbel);
            Document parsedXml = this.parseXml(source);
            this.buildXmlElementForNode((Branch)parsedXml, rbel, context);
            this.setCharset(parsedXml, rbel);
            rbel.addFacet(new RbelRootFacet<RbelXmlFacet>(rbel.getFacetOrFail(RbelXmlFacet.class)));
        }
        catch (DocumentException e) {
            log.trace("Exception while trying to parse XML. Trying as HTML (more lenient SAX parsing)", (Throwable)e);
            HTML_CONVERTER.parseHtml(rbel).ifPresent(document -> {
                HTML_CONVERTER.buildXmlElementForNode((Node)document, rbel, context);
                rbel.addFacet(new RbelRootFacet<RbelXmlFacet>(rbel.getFacetOrFail(RbelXmlFacet.class)));
            });
        }
    }

    @Override
    public boolean skipParsingOversizedContent() {
        return true;
    }

    private void setCharset(Document source, RbelElement rbel) {
        Optional.ofNullable(source.getXMLEncoding()).map(Charset::forName).ifPresent(charset -> rbel.setCharset(Optional.of(charset)));
    }

    private Document parseXml(InputSource source) throws DocumentException {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        return reader.read(source);
    }

    private InputSource buildInputSource(RbelElement parentElement) {
        if (parentElement.getCharset().isPresent()) {
            String text = parentElement.getRawStringContent();
            if (text == null) {
                throw new RbelConversionException("No raw string content available.");
            }
            InputSource source = new InputSource(new StringReader(text.trim()));
            source.setEncoding(parentElement.getElementCharset().name());
            return source;
        }
        return new InputSource(new ByteArrayInputStream(parentElement.getRawContent()));
    }

    private void buildXmlElementForNode(Branch branch, RbelElement parentElement, RbelConversionExecutor converter) {
        RbelMultiMap<RbelElement> childElements = new RbelMultiMap<RbelElement>();
        RbelXmlFacet xmlFacet = RbelXmlFacet.builder().childElements(childElements).namespaceUri(RbelXmlConverter.getNamespaceUri(branch)).namespacePrefix(RbelXmlConverter.getNamespacePrefix(branch)).build();
        parentElement.addFacet(xmlFacet);
        RbelXmlConverter.addAttributes(branch, parentElement, converter, childElements);
        this.addChildElements(branch, parentElement, converter, childElements);
        if (childElements.stream().map(Map.Entry::getKey).noneMatch(key -> key.equals(XML_TEXT_KEY))) {
            childElements.put(XML_TEXT_KEY, new RbelElement(new byte[0], parentElement));
        }
    }

    private void addChildElements(Branch branch, RbelElement parentElement, RbelConversionExecutor converter, RbelMultiMap<RbelElement> childElements) {
        for (Object child : branch.content()) {
            RbelElement element;
            if (child instanceof Text) {
                Text text = (Text)child;
                childElements.put(XML_TEXT_KEY, converter.convertElement(text.getText(), parentElement));
                continue;
            }
            if (child instanceof AbstractBranch) {
                AbstractBranch abstractBranch = (AbstractBranch)child;
                element = new RbelElement(abstractBranch.asXML().getBytes(parentElement.getElementCharset()), parentElement);
                this.buildXmlElementForNode((Branch)abstractBranch, element, converter);
                childElements.put(((AbstractBranch)child).getName(), element);
                continue;
            }
            if (child instanceof Namespace) {
                Namespace namespace = (Namespace)child;
                String childXmlName = namespace.asXML().split("=")[0];
                RbelElement namespaceAttributeElement = converter.convertElement(namespace.getText(), parentElement);
                namespaceAttributeElement.addFacet(new RbelXmlAttributeFacet());
                namespaceAttributeElement.addFacet(new RbelXmlNamespaceFacet());
                childElements.put(childXmlName, namespaceAttributeElement);
                continue;
            }
            if (child instanceof DefaultComment) continue;
            if (child instanceof DefaultProcessingInstruction) {
                DefaultProcessingInstruction instruction = (DefaultProcessingInstruction)child;
                element = RbelXmlConverter.convertProcessingInstruction(parentElement, converter, instruction);
                childElements.put(instruction.getTarget(), element);
                continue;
            }
            throw new RbelException("Could not convert XML element of type " + child.getClass().getSimpleName());
        }
    }

    private static RbelElement convertProcessingInstruction(RbelElement parentElement, RbelConversionExecutor converter, DefaultProcessingInstruction instruction) {
        RbelElement instructionElement = new RbelElement(instruction.asXML().getBytes(parentElement.getElementCharset()), parentElement);
        RbelMultiMap<RbelElement> childElements = new RbelMultiMap<RbelElement>();
        RbelXmlProcessingInstructionFacet instructionFacet = new RbelXmlProcessingInstructionFacet(instruction.getTarget());
        instructionElement.addFacet(instructionFacet);
        instructionElement.addFacet(new RbelMapFacet(childElements));
        for (Map.Entry attribute : instruction.getValues().entrySet()) {
            RbelElement value = converter.convertElement((String)attribute.getValue(), instructionElement);
            childElements.put((String)attribute.getKey(), value);
        }
        return instructionElement;
    }

    private static void addAttributes(Branch branch, RbelElement parentElement, RbelConversionExecutor converter, RbelMultiMap<RbelElement> childElements) {
        if (branch instanceof Element) {
            Element element = (Element)branch;
            for (Attribute attribute : element.attributes()) {
                RbelElement value = converter.convertElement(attribute.getText(), parentElement);
                value.addFacet(new RbelXmlAttributeFacet());
                childElements.put(attribute.getName(), value);
            }
        }
    }

    private static String getNamespaceUri(Branch branch) {
        return Optional.of(branch).filter(Element.class::isInstance).map(Element.class::cast).map(Element::getNamespaceURI).orElse(null);
    }

    private static String getNamespacePrefix(Branch branch) {
        return Optional.of(branch).filter(Element.class::isInstance).map(Element.class::cast).map(Element::getNamespacePrefix).orElse(null);
    }
}

