/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.xml;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.facets.xml.RbelXmlFacet;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RbelHtmlConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHtmlConverter.class);
    private static final String XML_TEXT_KEY = "text";
    private static final byte[] HTML_END_TAG = "</html>".getBytes();

    RbelHtmlConverter() {
    }

    Optional<Document> parseHtml(RbelElement element) {
        if (!element.getContent().endsTrimmedWithIgnoreCase(HTML_END_TAG, StandardCharsets.UTF_8)) {
            return Optional.empty();
        }
        return Optional.ofNullable(element.getRawStringContent()).map(String::trim).map(Jsoup::parse);
    }

    void buildXmlElementForNode(Node branch, RbelElement parentElement, RbelConversionExecutor converter) {
        RbelMultiMap<RbelElement> childElements = new RbelMultiMap<RbelElement>();
        parentElement.addFacet(RbelXmlFacet.builder().childElements(childElements).build());
        for (Node childNode : branch.childNodes()) {
            if (childNode instanceof TextNode) {
                TextNode textNode = (TextNode)childNode;
                childElements.put(XML_TEXT_KEY, converter.convertElement(textNode.getWholeText(), parentElement));
                continue;
            }
            RbelElement rbelChildElement = new RbelElement(childNode.toString().getBytes(), parentElement);
            childElements.put(childNode.nodeName(), rbelChildElement);
            this.buildXmlElementForNode(childNode, rbelChildElement, converter);
        }
        if (branch instanceof Element) {
            for (Attribute attribute : branch.attributes()) {
                childElements.put(attribute.getKey(), converter.convertElement(attribute.getValue(), parentElement));
            }
        }
    }
}

