/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.websocket;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.facets.websocket.RbelWebsocketMessageFacet;
import de.gematik.rbellogger.util.RbelContent;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelWebsocketMessageConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelWebsocketMessageConverter.class);
    private final RbelElement message;
    private final RbelConversionExecutor converter;
    private final RbelElement previousMessage;
    private boolean masked;
    private int lengthOfExtendedPayloadLength;

    public void parseWebsocketMessage() {
        boolean fin0Bit = (this.message.getContent().get(0) & 0x80) != 0;
        boolean rsv1Bit = (this.message.getContent().get(0) & 0x40) != 0;
        boolean rsv2Bit = (this.message.getContent().get(0) & 0x20) != 0;
        boolean rsv3Bit = (this.message.getContent().get(0) & 0x10) != 0;
        int opcode = this.message.getContent().get(0) & 0xF;
        this.masked = (this.message.getContent().get(1) & 0x80) != 0;
        int payloadLength = this.message.getContent().get(1) & 0x7F;
        this.lengthOfExtendedPayloadLength = RbelWebsocketMessageConverter.calculateExtendedPayloadLength(payloadLength);
        int actualPayloadLength = this.calculateActualPayloadLength(payloadLength);
        int messageLength = 2 + this.lengthOfExtendedPayloadLength + (this.masked ? 4 : 0) + actualPayloadLength;
        this.message.setUsedBytes(messageLength);
        RbelElement payloadElement = this.extractPayloadElement();
        RbelWebsocketMessageFacet websocketFacet = RbelWebsocketMessageFacet.builder().fin0Bit(RbelElement.wrap(this.message, fin0Bit)).rsv1Bit(RbelElement.wrap(this.message, rsv1Bit)).rsv2Bit(RbelElement.wrap(this.message, rsv2Bit)).rsv3Bit(RbelElement.wrap(this.message, rsv3Bit)).opcode(RbelElement.wrap(this.message, opcode)).masked(RbelElement.wrap(this.message, this.masked)).payloadLength(RbelElement.wrap(this.message, payloadLength)).payload(payloadElement).build();
        this.message.addFacet(websocketFacet);
        this.message.addFacet(new RbelRootFacet<RbelWebsocketMessageFacet>(websocketFacet));
        if (this.message.getFacet(RbelTcpIpMessageFacet.class).map(tcpFacet -> tcpFacet.isSameDirectionAs(this.previousMessage)).filter(facet -> this.previousMessage.hasFacet(RbelRequestFacet.class)).orElse(false).booleanValue()) {
            this.message.addFacet(new RbelRequestFacet("Websocket", false));
        } else {
            this.message.addFacet(new RbelResponseFacet("Websocket"));
        }
        this.converter.convertElement(payloadElement);
        log.debug("Parsed Websocket message with opcode {} and payload length {}\n\n{}", new Object[]{websocketFacet.getOpcode().getRawContent(), actualPayloadLength, payloadElement.printTreeStructure()});
    }

    private static int calculateExtendedPayloadLength(int payloadLength) {
        if (payloadLength == 126) {
            return 2;
        }
        if (payloadLength == 127) {
            return 8;
        }
        return 0;
    }

    private int calculateActualPayloadLength(int payloadLength) {
        if (payloadLength < 126) {
            return payloadLength;
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.message.getContent().subArray(2, 2 + this.lengthOfExtendedPayloadLength).toByteArray());
        if (payloadLength == 126) {
            return buffer.getShort();
        }
        return (int)buffer.getLong();
    }

    private RbelElement extractPayloadElement() {
        RbelContent rawPayloadBytes = this.message.getContent().subArray(2 + (this.masked ? 4 : 0) + this.lengthOfExtendedPayloadLength, this.message.getContent().size());
        if (this.masked) {
            byte[] maskingKey = this.message.getContent().toByteArray(2 + this.lengthOfExtendedPayloadLength, 2 + this.lengthOfExtendedPayloadLength + 4);
            byte[] maskedPayloadBytes = rawPayloadBytes.toByteArray();
            byte[] unmaskedPayloadBytes = new byte[maskedPayloadBytes.length];
            for (int i = 0; i < unmaskedPayloadBytes.length; ++i) {
                unmaskedPayloadBytes[i] = (byte)(maskedPayloadBytes[i] ^ maskingKey[i % 4]);
            }
            return RbelElement.builder().rawContent(unmaskedPayloadBytes).parentNode(this.message).build();
        }
        return RbelElement.builder().content(rawPayloadBytes).parentNode(this.message).build();
    }

    @ConstructorProperties(value={"message", "converter", "previousMessage"})
    @Generated
    public RbelWebsocketMessageConverter(RbelElement message, RbelConversionExecutor converter, RbelElement previousMessage) {
        this.message = message;
        this.converter = converter;
        this.previousMessage = previousMessage;
    }
}

