/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.websocket;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.facets.http.RbelHttpHeaderFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseFacet;
import de.gematik.rbellogger.facets.websocket.RbelWebsocketHandshakeFacet;
import java.util.Objects;
import java.util.Optional;

@ConverterInfo(onlyActivateFor={"websocket"})
public class RbelWebsocketHandshakeConverter
extends RbelConverterPlugin {
    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.CONTENT_ENRICHMENT;
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        Optional<RbelHttpMessageFacet> httpMessageFacet = rbelElement.getFacet(RbelHttpMessageFacet.class);
        if (httpMessageFacet.isEmpty()) {
            return;
        }
        if (rbelElement.hasFacet(RbelHttpRequestFacet.class) && RbelWebsocketHandshakeConverter.hasWebsocketHandshakeHeaders(httpMessageFacet)) {
            rbelElement.addFacet(new RbelWebsocketHandshakeFacet());
        } else if (rbelElement.getFacet(RbelHttpResponseFacet.class).stream().anyMatch(resp -> "101".equals(resp.getResponseCode().getRawStringContent())) && rbelElement.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getRequest).stream().anyMatch(req -> req.hasFacet(RbelWebsocketHandshakeFacet.class)) && RbelWebsocketHandshakeConverter.hasWebsocketHandshakeHeaders(httpMessageFacet)) {
            rbelElement.addFacet(new RbelWebsocketHandshakeFacet());
        }
    }

    private static boolean hasWebsocketHandshakeHeaders(Optional<RbelHttpMessageFacet> httpMessageFacet) {
        return httpMessageFacet.map(RbelHttpMessageFacet::getHeader).flatMap(el -> el.getFacet(RbelHttpHeaderFacet.class)).filter(map -> map.getCaseInsensitiveMatches("Upgrade").map(RbelElement::getRawStringContent).filter(Objects::nonNull).anyMatch(header -> header.contains("websocket"))).filter(map -> map.getCaseInsensitiveMatches("Connection").map(RbelElement::getRawStringContent).filter(Objects::nonNull).anyMatch(header -> header.contains("upgrade"))).isPresent();
    }
}

