/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.websocket;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseConverter;
import de.gematik.rbellogger.facets.websocket.RbelWebsocketHandshakeFacet;
import de.gematik.rbellogger.facets.websocket.RbelWebsocketMessageConverter;
import de.gematik.rbellogger.facets.websocket.RbelWebsocketMessageFacet;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(dependsOn={RbelHttpResponseConverter.class}, onlyActivateFor={"websocket"})
public class RbelWebsocketConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelWebsocketConverter.class);

    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.PROTOCOL_PARSING;
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        if (rbelElement.getParentNode() != null || !rbelElement.hasFacet(RbelTcpIpMessageFacet.class) || rbelElement.hasFacet(RbelWebsocketHandshakeFacet.class) || rbelElement.hasFacet(RbelHttpMessageFacet.class)) {
            return;
        }
        Optional<RbelElement> previousMessage = converter.getPreviousMessagesInSameConnectionAs(rbelElement).findFirst().filter(prevMessage -> prevMessage.hasFacet(RbelWebsocketMessageFacet.class) || prevMessage.hasFacet(RbelWebsocketHandshakeFacet.class));
        if (previousMessage.isEmpty()) {
            return;
        }
        try {
            new RbelWebsocketMessageConverter(rbelElement, converter, previousMessage.get()).parseWebsocketMessage();
        }
        catch (Exception e) {
            log.error("Error while parsing websocket message", (Throwable)e);
        }
    }
}

