/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.vau.vau_erp;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.vau.vau_erp.RbelVauErpFacet;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.CryptoUtils;
import de.gematik.rbellogger.util.RbelContent;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Optional;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"erp-vau"})
public class RbelErpVauDecrpytionConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelErpVauDecrpytionConverter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConversionExecutor context) {
        this.decipherVauMessage(element, context).ifPresent(vauMsg -> {
            element.addFacet((RbelFacet)vauMsg);
            element.addFacet(new RbelRootFacet<RbelVauErpFacet>((RbelVauErpFacet)vauMsg));
        });
    }

    private Optional<RbelVauErpFacet> decipherVauMessage(RbelElement element, RbelConversionExecutor converter) {
        return converter.getRbelKeyManager().getAllKeys().filter(key -> key.getKey() instanceof ECPrivateKey || key.getKey() instanceof SecretKey).map(key -> this.tryToDecipherWithKey(element, converter, (RbelKey)key)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<RbelVauErpFacet> tryToDecipherWithKey(RbelElement element, RbelConversionExecutor converter, RbelKey rbelKey) {
        RbelContent content = element.getContent();
        Optional<byte[]> decryptedBytes = this.decrypt(content, rbelKey.getKey());
        if (decryptedBytes.isPresent()) {
            try {
                log.trace("Succesfully deciphered VAU message! ({})", (Object)new String(decryptedBytes.get(), StandardCharsets.UTF_8));
                byte[] rawContent = content.toByteArray();
                if (this.isVauResponse(decryptedBytes)) {
                    return this.buildVauMessageFromCleartextResponse(converter, decryptedBytes.get(), rawContent, rbelKey, element);
                }
                return this.buildVauMessageFromCleartextRequest(converter, decryptedBytes.get(), rawContent, rbelKey, element);
            }
            catch (RuntimeException e) {
                log.error("Exception while deciphering VAU message:", (Throwable)e);
                throw e;
            }
        }
        return Optional.empty();
    }

    private ECPublicKey extractPublicKeyFromVauMessage(RbelContent encMessage) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ECPoint ecPoint = new ECPoint(new BigInteger(1, encMessage.toByteArray(1, 33)), new BigInteger(1, encMessage.toByteArray(33, 65)));
        ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, BrainpoolCurves.BP256);
        return (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(keySpec);
    }

    private boolean isVauResponse(Optional<byte[]> decryptedBytes) {
        return decryptedBytes.map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).map(s -> s.split("^1 [\\da-f]{32} ").length).map(length -> length > 1).orElse(false);
    }

    private Optional<byte[]> decrypt(RbelContent content, Key key) {
        if (key instanceof ECPrivateKey) {
            ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
            return this.decryptPrivateKey(content, ecPrivateKey);
        }
        if (key instanceof SecretKey) {
            return CryptoUtils.decrypt(content, key, 12, 16);
        }
        throw new RbelConversionException("Unexpected key-type encountered '" + key.getClass().getSimpleName() + "'");
    }

    private Optional<byte[]> decryptPrivateKey(RbelContent encMessage, ECPrivateKey secretKey) {
        try {
            if (encMessage.isEmpty() || encMessage.get(0) != 1) {
                return Optional.empty();
            }
            ECPublicKey otherSidePublicKey = this.extractPublicKeyFromVauMessage(encMessage);
            byte[] sharedSecret = CryptoUtils.ecka(secretKey, otherSidePublicKey);
            byte[] aesKeyBytes = CryptoUtils.hkdf(sharedSecret, "ecies-vau-transport", 16);
            SecretKeySpec aesKey = new SecretKeySpec(aesKeyBytes, "AES");
            RbelContent ciphertext = encMessage.subArray(65, encMessage.size());
            log.atTrace().addArgument(() -> Base64.getEncoder().encodeToString(aesKeyBytes)).addArgument(() -> Base64.getEncoder().encodeToString(ciphertext.toByteArray())).log("Decrypting. AesKey '{}' and ciphertext {}");
            return CryptoUtils.decrypt(ciphertext, aesKey);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Optional<RbelVauErpFacet> buildVauMessageFromCleartextRequest(RbelConversionExecutor converter, byte[] decryptedBytes, byte[] encryptedMessage, RbelKey decryptionKey, RbelElement parentNode) {
        String[] vauMessageParts = new String(decryptedBytes, StandardCharsets.UTF_8).split(" ", 5);
        SecretKeySpec responseKey = this.buildAesKeyFromHex(vauMessageParts[3]);
        converter.getRbelKeyManager().addKey("VAU Response-Key", responseKey, 0);
        return Optional.of(RbelVauErpFacet.builder().message(converter.convertElement(vauMessageParts[4], parentNode)).encryptedMessage(RbelElement.wrap(encryptedMessage, parentNode, null)).requestId(RbelElement.wrap(parentNode, vauMessageParts[2])).pVersionNumber(RbelElement.wrap(parentNode, Integer.parseInt(vauMessageParts[0]))).responseKey(RbelElement.wrap(parentNode, responseKey)).keyIdUsed(RbelElement.wrap(parentNode, decryptionKey.getKeyName())).decryptedPString(RbelElement.wrap(decryptedBytes, parentNode, new String(decryptedBytes, StandardCharsets.UTF_8))).keyUsed(Optional.of(decryptionKey)).build());
    }

    private Optional<RbelVauErpFacet> buildVauMessageFromCleartextResponse(RbelConversionExecutor converter, byte[] decryptedBytes, byte[] encryptedMessage, RbelKey keyUsed, RbelElement parentNode) {
        String[] vauMessageParts = new String(decryptedBytes, StandardCharsets.UTF_8).split(" ", 3);
        return Optional.of(RbelVauErpFacet.builder().message(converter.convertElement(vauMessageParts[2], parentNode)).encryptedMessage(RbelElement.wrap(parentNode, encryptedMessage)).requestId(RbelElement.wrap(parentNode, vauMessageParts[1])).pVersionNumber(RbelElement.wrap(parentNode, Integer.parseInt(vauMessageParts[0]))).keyIdUsed(RbelElement.wrap(parentNode, keyUsed.getKeyName())).keyUsed(Optional.of(keyUsed)).decryptedPString(RbelElement.wrap(parentNode, new String(decryptedBytes, StandardCharsets.UTF_8))).build());
    }

    private SecretKeySpec buildAesKeyFromHex(String hexEncodedKey) {
        try {
            return new SecretKeySpec(Hex.decode((String)hexEncodedKey), "AES");
        }
        catch (DecoderException e) {
            throw new RbelConversionException("Error during key decoding from '" + hexEncodedKey + "'", e);
        }
    }
}

