/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.vau.vau3;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelMapFacet;
import de.gematik.rbellogger.data.core.RbelNestedFacet;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.jackson.RbelCborFacet;
import de.gematik.rbellogger.facets.vau.vau3.RbelPrintableHashFacet;
import de.gematik.rbellogger.facets.vau.vau3.RbelVau3EncryptionFacet;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.util.CryptoUtils;
import de.gematik.rbellogger.util.RbelContent;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import org.bouncycastle.pqc.jcajce.provider.kyber.BCKyberPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"epa3-vau"})
public class RbelVauEpa3Converter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauEpa3Converter.class);
    private static final int HEADER_VERSION_INDEX = 0;
    private static final int HEADER_PU_INDEX = 1;
    private static final int HEADER_REQ_INDEX = 2;
    private static final int HEADER_REQ_COUNTER_INDEX = 3;
    private static final int HEADER_REQ_COUNTER_LENGTH = 8;
    private static final int HEADER_KEY_ID_INDEX = 11;
    private static final int HEADER_KEY_ID_LENGTH = 32;
    private static final int BODY_INDEX = 43;
    private static final int BODY_IV_LENGTH = 12;
    private static final int BODY_CT_INDEX = 55;
    private static final String VAU_3_HANDSHAKE_S_K1_C2S = "vau3_handshake_s_k1_c2s_";
    private static final String VAU_DEBUG_K1_C2S = "VAU-DEBUG-S_K1_c2s";
    private static final String VAU_DEBUG_K1_S2C = "VAU-DEBUG-S_K1_s2c";
    private static final String K1_S2C_NOTE = "S_K1_s2c, absent in a real-life implementation";
    private static final String VAU_3_PAYLOAD_KEYS = "vau_non_pu_tracing_";
    private static final String AEAD_CT_KEY_CONFIRMATION_NOTE = "Decrypted AEAD_ct_key_confirmation. This is the server's transcript hash. Decryption for clarification purposes only. In a real-life implementation, this would be done by the client.";
    public static final String CONTENT = "content";

    @Override
    public void consumeElement(RbelElement element, RbelConversionExecutor context) {
        context.waitForAllElementsBeforeGivenToBeParsed(element.findRootElement());
        if (element.hasFacet(RbelCborFacet.class)) {
            this.tryToParseVauEpa3HandshakeMessage(element, context);
        } else if (element.getParentNode() != null && element.getParentNode().hasFacet(RbelHttpMessageFacet.class)) {
            this.tryToExtractVauNonPuTracingKeys(element, context);
            this.tryToParseVauEpa3Message(element, context);
        }
    }

    private void tryToParseVauEpa3Message(RbelElement element, RbelConversionExecutor context) {
        context.getRbelKeyManager().getAllKeys().filter(key -> key.getKey() instanceof SecretKeySpec).filter(key -> key.getKey().getAlgorithm().equals("AES")).filter(key -> key.getKeyName().startsWith(VAU_3_PAYLOAD_KEYS)).forEach(key -> this.decryptEpa3VauSuccessfull(element, key.getKey(), context));
    }

    private boolean decryptEpa3VauSuccessfull(RbelElement element, Key key, RbelConversionExecutor context) {
        try {
            byte[] rawContent = element.getRawContent();
            byte[] header = ArrayUtils.subarray((byte[])rawContent, (int)0, (int)43);
            byte[] iv = ArrayUtils.subarray((byte[])rawContent, (int)43, (int)55);
            byte[] ct = ArrayUtils.subarray((byte[])rawContent, (int)55, (int)rawContent.length);
            byte[] cleartext = RbelVauEpa3Converter.performActualDecryption(key, iv, ct, header);
            if (log.isTraceEnabled()) {
                log.trace("Decrypted VAU EPA3: {}", (Object)new String(cleartext));
            }
            RbelElement headerElement = context.convertElement(header, element);
            byte[] reqCounterBytes = Arrays.copyOfRange(header, 3, 11);
            headerElement.addFacet(new RbelMapFacet(new RbelMultiMap<RbelElement>().with("version", RbelElement.wrap(new byte[]{header[0]}, headerElement, header[0])).with("pu", RbelElement.wrap(new byte[]{header[1]}, headerElement, header[1])).with("req", RbelElement.wrap(new byte[]{header[2]}, headerElement, header[2])).with("reqCtr", RbelElement.wrap(reqCounterBytes, headerElement, ByteBuffer.wrap(reqCounterBytes).getLong())).with("keyId", RbelElement.wrap(Arrays.copyOfRange(header, 11, 43), headerElement, new BigInteger(Arrays.copyOfRange(header, 11, 43))))));
            RbelElement cleartextElement = context.convertElement(cleartext, element);
            element.addFacet(new RbelVau3EncryptionFacet(cleartextElement, headerElement));
            return true;
        }
        catch (Exception e) {
            log.trace("Failed to parse VAU EPA3: ", (Throwable)e);
            return false;
        }
    }

    private static byte[] performActualDecryption(Key key, byte[] iv, byte[] ciphertext, byte[] ad) {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, key, new GCMParameterSpec(128, iv));
        cipher.updateAAD(ad);
        return cipher.doFinal(ciphertext);
    }

    private void tryToExtractVauNonPuTracingKeys(RbelElement element, RbelConversionExecutor context) {
        Optional.ofNullable(element.getParentNode()).flatMap(el -> el.getFacet(RbelHttpMessageFacet.class)).map(RbelHttpMessageFacet::getHeader).flatMap(header -> header.getFirst("VAU-nonPU-Tracing")).map(RbelElement::getRawStringContent).map(keyString -> keyString.split(" ")).stream().flatMap(Stream::of).map(Base64.getDecoder()::decode).map(key -> new SecretKeySpec((byte[])key, "AES")).map(key -> new RbelKey((Key)key, VAU_3_PAYLOAD_KEYS + String.valueOf(UUID.randomUUID()), 0)).forEach(key -> context.getRbelKeyManager().addKey((RbelKey)key));
    }

    private void tryToParseVauEpa3HandshakeMessage(RbelElement element, RbelConversionExecutor context) {
        try {
            Optional<RbelElement> messageType = element.getFirst("MessageType");
            if (messageType.isPresent()) {
                String messageTypeContent;
                switch (messageTypeContent = messageType.get().getFirst(CONTENT).map(RbelElement::getRawStringContent).orElse("")) {
                    case "M1": {
                        this.parseM1(element, context);
                        break;
                    }
                    case "M2": {
                        this.parseM2(element, context);
                        break;
                    }
                    case "M3": {
                        this.parseM3(element, context);
                        break;
                    }
                    case "M4": {
                        this.parseM4(element, context);
                        break;
                    }
                    default: {
                        element.addFacet(new RbelNoteFacet("Unknown VAU EPA3 message type: " + messageTypeContent));
                    }
                }
            }
        }
        catch (RuntimeException e) {
            log.trace("Failed to parse VAU EPA3: {}", (Object)e.getMessage());
        }
    }

    private void parseM3(RbelElement element, RbelConversionExecutor context) {
        Optional<RbelElement> aeadCtKeyConfirmation = element.getFirst("AEAD_ct_key_confirmation");
        Optional<RbelElement> aeadCt = element.getFirst("AEAD_ct");
        if (aeadCtKeyConfirmation.isEmpty() || aeadCt.isEmpty()) {
            return;
        }
        aeadCtKeyConfirmation.get().addFacet(new RbelNoteFacet("aead_ciphertext_key_confirmation"));
        aeadCt.get().addFacet(new RbelNoteFacet("aead_ciphertext_msg_3"));
        for (RbelKey key : context.getRbelKeyManager().getAllKeys().toList()) {
            Key key2 = key.getKey();
            if (!(key2 instanceof SecretKeySpec)) continue;
            SecretKeySpec secretKeySpec = (SecretKeySpec)key2;
            if (!key.getKey().getAlgorithm().equals("AES") || !key.getKeyName().startsWith(VAU_3_HANDSHAKE_S_K1_C2S) || !this.tryToDecipherAeadCt(aeadCt.get(), context, secretKeySpec)) continue;
            break;
        }
    }

    private void parseM2(RbelElement element, RbelConversionExecutor context) {
        Optional<RbelElement> ecdhCt = element.getFirst("ECDH_ct");
        Optional<RbelElement> kyber768Ct = element.getFirst("Kyber768_ct");
        Optional<RbelElement> aeadCt = element.getFirst("AEAD_ct");
        if (ecdhCt.isEmpty() || kyber768Ct.isEmpty() || aeadCt.isEmpty()) {
            return;
        }
        ecdhCt.get().addFacet(new RbelNoteFacet("ECC ciphertext of the server for this handshake"));
        kyber768Ct.get().addFacet(new RbelNoteFacet("Kyber768 ciphertext of the server for this handshake"));
        aeadCt.get().addFacet(new RbelNoteFacet("aead_ciphertext_msg_2"));
        Optional<byte[]> s2cKey = RbelVauEpa3Converter.extractKeyFromHttpHeader(aeadCt.get(), VAU_DEBUG_K1_S2C, K1_S2C_NOTE);
        if (s2cKey.isEmpty()) {
            return;
        }
        this.tryToDecipherAeadCt(aeadCt.get(), context, new SecretKeySpec(s2cKey.get(), "AES"));
        RbelVauEpa3Converter.manageClientToServerKey(element, context);
    }

    private void parseM4(RbelElement element, RbelConversionExecutor context) {
        RbelElement ctKeyConfirmation = element.getFirst("AEAD_ct_key_confirmation").orElseThrow();
        RbelContent encodedHashBytes = ctKeyConfirmation.getFirst(CONTENT).map(RbelElement::getContent).orElseThrow();
        RbelVauEpa3Converter.extractKeyFromHttpHeader(element, "VAU-DEBUG-S_K2_s2c_keyConfirmation", K1_S2C_NOTE).map(key -> new SecretKeySpec((byte[])key, "AES")).flatMap(key -> CryptoUtils.decrypt(encodedHashBytes, key)).ifPresent(decrypted -> {
            RbelPrintableHashFacet printableHashFacet = new RbelPrintableHashFacet("SHA-256 Hash of the transcript");
            ctKeyConfirmation.addFacet(new RbelNestedFacet(new RbelElement((byte[])decrypted, ctKeyConfirmation).addFacet(printableHashFacet).addFacet(new RbelRootFacet<RbelPrintableHashFacet>(printableHashFacet)), "decrypted"));
            ctKeyConfirmation.addFacet(new RbelNoteFacet(AEAD_CT_KEY_CONFIRMATION_NOTE));
        });
    }

    private static void manageClientToServerKey(RbelElement element, RbelConversionExecutor context) {
        RbelVauEpa3Converter.extractKeyFromHttpHeader(element, VAU_DEBUG_K1_C2S, "S_K1_c2s, absent in a real-life implementation").map(key -> new SecretKeySpec((byte[])key, "AES")).map(key -> new RbelKey((Key)key, VAU_3_HANDSHAKE_S_K1_C2S + String.valueOf(UUID.randomUUID()), 0)).ifPresent(rbelKey -> context.getRbelKeyManager().addKey((RbelKey)rbelKey));
    }

    private boolean tryToDecipherAeadCt(RbelElement rbelElement, RbelConversionExecutor context, SecretKeySpec aesKey) {
        Optional<RbelElement> contentNode = rbelElement.getFirst(CONTENT);
        if (contentNode.isEmpty()) {
            return false;
        }
        Optional<byte[]> decrypt = CryptoUtils.decrypt(contentNode.get().getContent(), aesKey, 12, 16);
        if (decrypt.isEmpty()) {
            return false;
        }
        RbelElement nestedElement = context.convertElement(decrypt.get(), rbelElement);
        nestedElement.addFacet(new RbelNoteFacet("Decrypted AEAD_ct element. Decryption for clarification purposes only. In a real-life implementation, this would be done by the client."));
        rbelElement.addFacet(new RbelNestedFacet(nestedElement, "decrypted_content"));
        return true;
    }

    private static Optional<byte[]> extractKeyFromHttpHeader(RbelElement rbelElement, String keyName, String keyNote) {
        return rbelElement.findRootElement().getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getHeader).flatMap(e -> e.getFirst(keyName)).map(e -> e.addFacet(new RbelNoteFacet(keyNote))).map(RbelElement::getRawContent).map(Base64.getDecoder()::decode);
    }

    private void parseM1(RbelElement element, RbelConversionExecutor context) {
        Optional<RbelElement> ecdhPk = element.getFirst("ECDH_PK");
        Optional<RbelElement> kyber768Pk = element.getFirst("Kyber768_PK");
        if (ecdhPk.isEmpty() || kyber768Pk.isEmpty()) {
            return;
        }
        ecdhPk.get().addFacet(new RbelNoteFacet("ECC public key of the client for this handshake"));
        kyber768Pk.get().addFacet(new RbelNoteFacet("Kyber public key of the client for this handshake (Concatenation of the two kyber parameters)"));
        this.tryToAddEccKeyToKeyManager(element, context);
    }

    private void tryToAddEccKeyToKeyManager(RbelElement element, RbelConversionExecutor context) {
        RbelKeyManager keyManager = context.getRbelKeyManager();
        String uuid = UUID.randomUUID().toString();
        element.getFirst("ECDH_PK").map(this::toEcPublicKey).ifPresent(key -> keyManager.addKey("vau3_handshake_client_ecdh_pk_" + uuid, (Key)key, 0));
        element.getFirst("Kyber768_PK").map(this::toKyberPublicKey).ifPresent(key -> keyManager.addKey("vau3_handshake_client_kyber_pk" + uuid, (Key)key, 0));
    }

    private Key toKyberPublicKey(RbelElement element) {
        return new BCKyberPublicKey(new KyberPublicKeyParameters(KyberParameters.kyber768, element.getRawContent()));
    }

    public ECPublicKey toEcPublicKey(RbelElement element) {
        RbelElement xElement = element.getFirst("x").orElseThrow();
        RbelElement yElement = element.getFirst("y").orElseThrow();
        BigInteger x = new BigInteger(1, xElement.getRawContent(), 0, xElement.getRawContent().length);
        BigInteger y = new BigInteger(1, yElement.getRawContent(), 0, yElement.getRawContent().length);
        X9ECParameters ecp = SECNamedCurves.getByName((String)"secp256r1");
        ECCurve ecCurve = ecp.getCurve();
        ECPoint ecPoint = ecCurve.createPoint(x, y);
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        ECPublicKeySpec ecKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance("ECDH", "BC");
        return (ECPublicKey)keyFactory.generatePublic((KeySpec)ecKeySpec);
    }
}

