/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.vau.vau;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelBinaryFacet;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.http.RbelHttpHeaderFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.facets.vau.vau.RbelUndecipherableVauEpaFacet;
import de.gematik.rbellogger.facets.vau.vau.RbelVauEpaFacet;
import de.gematik.rbellogger.facets.vau.vau.RbelVauEpaKeyDeriver;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.CryptoUtils;
import de.gematik.rbellogger.util.RbelContent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"epa-vau"}, dependsOn={RbelVauEpaKeyDeriver.class})
public class RbelVauEpaConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelVauEpaConverter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConversionExecutor context) {
        context.waitForAllElementsBeforeGivenToBeParsed(element.findRootElement());
        this.tryToExtractRawVauContent(element).flatMap(content -> this.decipherVauMessage((byte[])content, context, element)).ifPresent(vauMsg -> {
            element.addFacet((RbelFacet)vauMsg);
            element.addFacet(new RbelRootFacet<RbelVauEpaFacet>((RbelVauEpaFacet)vauMsg));
            context.convertElement(vauMsg.getMessage());
        });
    }

    private Optional<byte[]> tryToExtractRawVauContent(RbelElement element) {
        if (element.getParentNode() != null && element.getParentNode().hasFacet(RbelJsonFacet.class)) {
            try {
                return Optional.ofNullable(Base64.getDecoder().wrap(element.getContent().toInputStream()).readAllBytes());
            }
            catch (IOException | IllegalArgumentException e) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(element.getRawContent());
    }

    private Optional<RbelVauEpaFacet> decipherVauMessage(byte[] content, RbelConversionExecutor converter, RbelElement parentNode) {
        ArrayList<RbelNoteFacet> errorNotes = new ArrayList<RbelNoteFacet>();
        Optional<Pair<byte[], byte[]>> splitOptional = this.splitVauMessage(content);
        if (splitOptional.isEmpty()) {
            return Optional.empty();
        }
        Pair<byte[], byte[]> splitVauMessage = splitOptional.get();
        List<RbelKey> potentialVauKeys = converter.getRbelKeyManager().getAllKeys().filter(key -> key.getKeyName().startsWith(Hex.toHexString((byte[])((byte[])splitVauMessage.getKey())))).filter(key -> key.getKey() instanceof SecretKey).toList();
        for (RbelKey rbelKey : potentialVauKeys) {
            Optional<Object> decryptedBytes;
            try {
                decryptedBytes = Optional.ofNullable(CryptoUtils.decryptUnsafe(RbelContent.of((byte[])splitVauMessage.getValue()), rbelKey.getKey(), 12, 16));
            }
            catch (GeneralSecurityException e) {
                errorNotes.add(RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.ERROR).value("Error during decryption: " + e.getMessage()).build());
                decryptedBytes = Optional.empty();
            }
            if (!decryptedBytes.isPresent()) continue;
            try {
                if (log.isTraceEnabled()) {
                    log.trace("Succesfully deciphered VAU message! ({})", (Object)new String((byte[])decryptedBytes.get()));
                }
                return this.buildVauMessageFromCleartext(converter, splitVauMessage, (byte[])decryptedBytes.get(), parentNode, rbelKey);
            }
            catch (RuntimeException e) {
                log.error("Exception while building cleartext VAU message:", (Throwable)e);
                throw new RbelConversionException("Exception while building cleartext VAU message", e);
            }
        }
        if (potentialVauKeys.isEmpty()) {
            errorNotes.add(RbelNoteFacet.builder().value("Found no matching key! (Was the handshake logged?) key-name: '" + Hex.toHexString((byte[])((byte[])splitVauMessage.getKey())) + "'").style(RbelNoteFacet.NoteStyling.WARN).build());
            errorNotes.add(RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.INFO).value("Known keys: <br/>" + converter.getRbelKeyManager().getAllKeys().map(RbelKey::getKeyName).collect(Collectors.joining("<br/>"))).build());
        }
        if (parentNode.getParentNode() != null && parentNode.getParentNode().hasFacet(RbelHttpMessageFacet.class) && parentNode.getFacets().isEmpty()) {
            parentNode.addFacet(new RbelUndecipherableVauEpaFacet(errorNotes));
        }
        return Optional.empty();
    }

    private Optional<RbelVauEpaFacet> buildVauMessageFromCleartext(RbelConversionExecutor converter, Pair<byte[], byte[]> splitVauMessage, byte[] decryptedBytes, RbelElement parentNode, RbelKey rbelKey) {
        String cleartextString = new String(decryptedBytes);
        if (cleartextString.startsWith("VAUClientSigFin") || cleartextString.startsWith("VAUServerFin")) {
            RbelElement decryptedPayload = new RbelElement(decryptedBytes, parentNode);
            decryptedPayload.addFacet(new RbelBinaryFacet());
            return Optional.of(RbelVauEpaFacet.builder().message(decryptedPayload).encryptedMessage(RbelElement.wrap(parentNode, splitVauMessage.getValue())).keyIdUsed(RbelElement.wrap(parentNode, rbelKey.getKeyName().split("_")[0])).keyUsed(Optional.of(rbelKey)).build());
        }
        return Optional.of(this.fromRaw(splitVauMessage, converter, decryptedBytes, parentNode, rbelKey));
    }

    private RbelVauEpaFacet fromRaw(Pair<byte[], byte[]> payloadPair, RbelConversionExecutor converter, byte[] decryptedBytes, RbelElement parentNode, RbelKey rbelKey) {
        byte[] raw = new byte[decryptedBytes.length - 8 - 1];
        System.arraycopy(decryptedBytes, 9, raw, 0, raw.length);
        byte[] sequenceNumberBytes = new byte[4];
        System.arraycopy(decryptedBytes, 5, sequenceNumberBytes, 0, 4);
        int sequenceNumber = ByteBuffer.wrap(sequenceNumberBytes).getInt();
        byte[] pHeaderInformation = new byte[13];
        System.arraycopy(decryptedBytes, 0, pHeaderInformation, 0, pHeaderInformation.length);
        byte[] numberOfBytesInBytes = new byte[4];
        System.arraycopy(raw, 0, numberOfBytesInBytes, 0, 4);
        int numberOfBytes = ByteBuffer.wrap(numberOfBytesInBytes).getInt();
        byte[] headerFieldInBytes = new byte[numberOfBytes];
        System.arraycopy(raw, 4, headerFieldInBytes, 0, numberOfBytes);
        String headerField = new String(headerFieldInBytes, StandardCharsets.US_ASCII);
        RbelElement headerElement = new RbelElement(headerFieldInBytes, parentNode);
        RbelHttpHeaderFacet header = new RbelHttpHeaderFacet();
        headerElement.addFacet(header);
        Arrays.stream(headerField.split("\r\n")).map(field -> field.split(":", 2)).forEach(field -> header.put(field[0].trim(), converter.convertElement(field[1], headerElement)));
        byte[] body = new byte[raw.length - 4 - numberOfBytes];
        System.arraycopy(raw, 4 + numberOfBytes, body, 0, body.length);
        String pHeaderHexString = String.join((CharSequence)" ", Hex.toHexString((byte[])pHeaderInformation).split("(?<=\\G.{2})"));
        return RbelVauEpaFacet.builder().message(new RbelElement(body, parentNode)).additionalHeaders(headerElement).encryptedMessage(RbelElement.wrap((byte[])payloadPair.getValue(), parentNode, null)).keyIdUsed(RbelElement.wrap(parentNode, Hex.toHexString((byte[])((byte[])payloadPair.getKey())))).pVersionNumber(RbelElement.wrap(parentNode, decryptedBytes[0])).sequenceNumber(RbelElement.wrap(parentNode, sequenceNumber)).keyUsed(Optional.ofNullable(rbelKey)).pHeaderInformation(RbelElement.wrap(parentNode, pHeaderHexString)).build();
    }

    private Optional<Pair<byte[], byte[]>> splitVauMessage(byte[] vauMessage) {
        try {
            byte[] keyID = new byte[32];
            System.arraycopy(vauMessage, 0, keyID, 0, 32);
            byte[] enc = new byte[vauMessage.length - 32];
            System.arraycopy(vauMessage, 32, enc, 0, vauMessage.length - 32);
            return Optional.of(Pair.of((Object)keyID, (Object)enc));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }
}

