/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.uri;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.facets.uri.RbelUriParameterFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import j2html.tags.specialized.DivTag;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class RbelUriFacet
implements RbelFacet {
    private final RbelElement basicPath;
    private final RbelElement scheme;
    private final RbelElement path;
    private final RbelElement authority;
    private final RbelElement userInfo;
    private final RbelElement query;
    private final RbelElement host;
    private final RbelElement port;
    private final List<RbelElement> queryParameters;

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        RbelMultiMap<RbelElement> result = new RbelMultiMap<RbelElement>();
        this.queryParameters.forEach(el -> result.put(el.getFacetOrFail(RbelUriParameterFacet.class).getKeyAsString(), (RbelElement)el));
        result.put("basicPath", this.basicPath);
        result.putIfNotNull("scheme", this.scheme);
        result.putIfNotNull("path", this.path);
        result.putIfNotNull("authority", this.authority);
        result.putIfNotNull("userInfo", this.userInfo);
        result.putIfNotNull("query", this.query);
        result.putIfNotNull("host", this.host);
        result.putIfNotNull("port", this.port);
        return result;
    }

    public String getBasicPathString() {
        return this.basicPath.seekValue(String.class).orElseThrow();
    }

    public Optional<RbelElement> getQueryParameter(String key) {
        Objects.requireNonNull(key);
        return this.queryParameters.stream().map(element -> element.getFacetOrFail(RbelUriParameterFacet.class)).filter(e -> e.getKeyAsString().equals(key)).map(RbelUriParameterFacet::getValue).findFirst();
    }

    @ConstructorProperties(value={"basicPath", "scheme", "path", "authority", "userInfo", "query", "host", "port", "queryParameters"})
    @Generated
    RbelUriFacet(RbelElement basicPath, RbelElement scheme, RbelElement path, RbelElement authority, RbelElement userInfo, RbelElement query, RbelElement host, RbelElement port, List<RbelElement> queryParameters) {
        this.basicPath = basicPath;
        this.scheme = scheme;
        this.path = path;
        this.authority = authority;
        this.userInfo = userInfo;
        this.query = query;
        this.host = host;
        this.port = port;
        this.queryParameters = queryParameters;
    }

    @Generated
    public static RbelUriFacetBuilder builder() {
        return new RbelUriFacetBuilder();
    }

    @Generated
    public RbelElement getBasicPath() {
        return this.basicPath;
    }

    @Generated
    public RbelElement getScheme() {
        return this.scheme;
    }

    @Generated
    public RbelElement getPath() {
        return this.path;
    }

    @Generated
    public RbelElement getAuthority() {
        return this.authority;
    }

    @Generated
    public RbelElement getUserInfo() {
        return this.userInfo;
    }

    @Generated
    public RbelElement getQuery() {
        return this.query;
    }

    @Generated
    public RbelElement getHost() {
        return this.host;
    }

    @Generated
    public RbelElement getPort() {
        return this.port;
    }

    @Generated
    public List<RbelElement> getQueryParameters() {
        return this.queryParameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelUriFacet)) {
            return false;
        }
        RbelUriFacet other = (RbelUriFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$basicPath = this.getBasicPath();
        RbelElement other$basicPath = other.getBasicPath();
        if (this$basicPath == null ? other$basicPath != null : !this$basicPath.equals(other$basicPath)) {
            return false;
        }
        RbelElement this$scheme = this.getScheme();
        RbelElement other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        RbelElement this$path = this.getPath();
        RbelElement other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        RbelElement this$authority = this.getAuthority();
        RbelElement other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !this$authority.equals(other$authority)) {
            return false;
        }
        RbelElement this$userInfo = this.getUserInfo();
        RbelElement other$userInfo = other.getUserInfo();
        if (this$userInfo == null ? other$userInfo != null : !this$userInfo.equals(other$userInfo)) {
            return false;
        }
        RbelElement this$query = this.getQuery();
        RbelElement other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        RbelElement this$host = this.getHost();
        RbelElement other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        RbelElement this$port = this.getPort();
        RbelElement other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        List<RbelElement> this$queryParameters = this.getQueryParameters();
        List<RbelElement> other$queryParameters = other.getQueryParameters();
        return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelUriFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $basicPath = this.getBasicPath();
        result = result * 59 + ($basicPath == null ? 43 : $basicPath.hashCode());
        RbelElement $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        RbelElement $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        RbelElement $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : $authority.hashCode());
        RbelElement $userInfo = this.getUserInfo();
        result = result * 59 + ($userInfo == null ? 43 : $userInfo.hashCode());
        RbelElement $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        RbelElement $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        RbelElement $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        List<RbelElement> $queryParameters = this.getQueryParameters();
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelUriFacet(basicPath=" + String.valueOf(this.getBasicPath()) + ", scheme=" + String.valueOf(this.getScheme()) + ", path=" + String.valueOf(this.getPath()) + ", authority=" + String.valueOf(this.getAuthority()) + ", userInfo=" + String.valueOf(this.getUserInfo()) + ", query=" + String.valueOf(this.getQuery()) + ", host=" + String.valueOf(this.getHost()) + ", port=" + String.valueOf(this.getPort()) + ", queryParameters=" + String.valueOf(this.getQueryParameters()) + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelUriFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                RbelUriFacet uriFacet = element.getFacetOrFail(RbelUriFacet.class);
                String originalUrl = element.getRawStringContent();
                ContainerTag urlContent = this.renderUrlContent(renderingToolkit, uriFacet, originalUrl);
                if (element.traverseAndReturnNestedMembers().isEmpty()) {
                    return ((DivTag)TagCreator.div().with((DomContent)urlContent)).with(RbelHtmlRenderingToolkit.addNotes(element, new String[0]));
                }
                return RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with((DomContent)((DivTag)((DivTag)((DivTag)TagCreator.div().withClass("tile is-child pe-2")).with((DomContent)urlContent)).with(RbelHtmlRenderingToolkit.addNotes(element, new String[0]))).with(renderingToolkit.convertNested(element))));
            }

            private ContainerTag renderUrlContent(RbelHtmlRenderingToolkit renderingToolkit, RbelUriFacet uriFacet, String originalUrl) {
                if (!originalUrl.contains("?")) {
                    return TagCreator.div((DomContent[])new DomContent[]{new UnescapedText(originalUrl)});
                }
                ContainerTag div = TagCreator.div((String)(uriFacet.getBasicPathString() + "?")).with((DomContent)TagCreator.br());
                boolean firstElement = true;
                for (RbelElement queryElementEntry : uriFacet.getQueryParameters()) {
                    RbelUriParameterFacet parameterFacet = queryElementEntry.getFacetOrFail(RbelUriParameterFacet.class);
                    String shadedStringContent = renderingToolkit.shadeValue(parameterFacet.getValue(), Optional.of(parameterFacet.getKeyAsString())).map(content -> String.valueOf(queryElementEntry.getKey()) + "=" + content).orElse(queryElementEntry.getRawStringContent());
                    div.with((DomContent)TagCreator.div((String)((firstElement ? "" : "&") + shadedStringContent)).with(RbelHtmlRenderingToolkit.addNotes(queryElementEntry, " ms-6")));
                    firstElement = false;
                }
                return div;
            }
        });
    }

    @Generated
    public static class RbelUriFacetBuilder {
        @Generated
        private RbelElement basicPath;
        @Generated
        private RbelElement scheme;
        @Generated
        private RbelElement path;
        @Generated
        private RbelElement authority;
        @Generated
        private RbelElement userInfo;
        @Generated
        private RbelElement query;
        @Generated
        private RbelElement host;
        @Generated
        private RbelElement port;
        @Generated
        private List<RbelElement> queryParameters;

        @Generated
        RbelUriFacetBuilder() {
        }

        @Generated
        public RbelUriFacetBuilder basicPath(RbelElement basicPath) {
            this.basicPath = basicPath;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder scheme(RbelElement scheme) {
            this.scheme = scheme;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder path(RbelElement path) {
            this.path = path;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder authority(RbelElement authority) {
            this.authority = authority;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder userInfo(RbelElement userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder query(RbelElement query) {
            this.query = query;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder host(RbelElement host) {
            this.host = host;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder port(RbelElement port) {
            this.port = port;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder queryParameters(List<RbelElement> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        @Generated
        public RbelUriFacet build() {
            return new RbelUriFacet(this.basicPath, this.scheme, this.path, this.authority, this.userInfo, this.query, this.host, this.port, this.queryParameters);
        }

        @Generated
        public String toString() {
            return "RbelUriFacet.RbelUriFacetBuilder(basicPath=" + String.valueOf(this.basicPath) + ", scheme=" + String.valueOf(this.scheme) + ", path=" + String.valueOf(this.path) + ", authority=" + String.valueOf(this.authority) + ", userInfo=" + String.valueOf(this.userInfo) + ", query=" + String.valueOf(this.query) + ", host=" + String.valueOf(this.host) + ", port=" + String.valueOf(this.port) + ", queryParameters=" + String.valueOf(this.queryParameters) + ")";
        }
    }
}

