/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.uri;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.facets.uri.RbelUriFacet;
import de.gematik.rbellogger.facets.uri.RbelUriParameterFacet;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelUriConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelUriConverter.class);

    public List<RbelElement> extractParameterMap(URI uri, RbelConversionExecutor context, String originalContent, RbelElement parentNode) {
        if (StringUtils.isEmpty((CharSequence)uri.getQuery())) {
            return List.of();
        }
        String[] split = originalContent.split("\\?");
        if (split.length < 2) {
            return List.of();
        }
        return Stream.of(split[1].split("\\&")).filter(StringUtils::isNotEmpty).map(param -> {
            RbelElement paramPair = new RbelElement(param.getBytes(parentNode.getElementCharset()), parentNode);
            String[] splitParams = param.split("\\=", 2);
            if (splitParams.length == 1) {
                paramPair.addFacet(RbelUriParameterFacet.builder().key(RbelElement.wrap(paramPair, splitParams[0])).value(context.convertElement("", paramPair)).build());
            } else {
                paramPair.addFacet(RbelUriParameterFacet.builder().key(RbelElement.wrap(paramPair, splitParams[0])).value(context.convertElement(URLDecoder.decode(splitParams[1], StandardCharsets.UTF_8).getBytes(parentNode.getElementCharset()), paramPair)).build());
            }
            return paramPair;
        }).toList();
    }

    private static URI parseUri(String rawStringContent) {
        try {
            boolean hasProtocol;
            URI uri = new URI(rawStringContent);
            boolean hasQuery = uri.getQuery() != null;
            boolean bl = hasProtocol = uri.getScheme() != null;
            if (hasQuery || hasProtocol || rawStringContent.startsWith("/")) {
                return uri;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void consumeElement(RbelElement rbel, RbelConversionExecutor context) {
        if (ArrayUtils.indexOf((byte[])rbel.getRawContent(), (byte)10) >= 0) {
            return;
        }
        String content = rbel.getRawStringContent();
        if (content == null) {
            return;
        }
        URI uri = RbelUriConverter.parseUri(content);
        if (uri == null) {
            return;
        }
        String[] pathParts = content.split("\\?", 2);
        RbelUriFacet.RbelUriFacetBuilder uriFacetBuilder = RbelUriFacet.builder().basicPath(RbelElement.wrap(rbel, pathParts[0]));
        if (uri.getScheme() != null) {
            uriFacetBuilder.scheme(RbelElement.wrap(rbel, uri.getScheme()));
        }
        if (uri.getAuthority() != null) {
            uriFacetBuilder.authority(RbelElement.wrap(rbel, uri.getAuthority()));
        }
        if (uri.getUserInfo() != null) {
            uriFacetBuilder.userInfo(RbelElement.wrap(rbel, uri.getUserInfo()));
        }
        if (uri.getPath() != null) {
            uriFacetBuilder.path(RbelElement.wrap(rbel, uri.getPath()));
        }
        if (uri.getQuery() != null) {
            uriFacetBuilder.query(RbelElement.wrap(rbel, uri.getQuery()));
        }
        if (uri.getHost() != null) {
            uriFacetBuilder.host(RbelElement.wrap(rbel, uri.getHost()));
        }
        if (uri.getPort() >= 0) {
            uriFacetBuilder.port(RbelElement.wrap(rbel, uri.getPort()));
        }
        if (pathParts.length > 1) {
            uriFacetBuilder.queryParameters(this.extractParameterMap(uri, context, rbel.getRawStringContent(), rbel));
        } else {
            uriFacetBuilder.queryParameters(List.of());
        }
        rbel.addFacet(uriFacetBuilder.build());
    }
}

