/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.sicct;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelBinaryFacet;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.sicct.RbelSicctCommandFacet;
import de.gematik.rbellogger.facets.sicct.RbelSicctEnvelopeFacet;
import de.gematik.rbellogger.facets.sicct.RbelSicctHeaderFacet;
import de.gematik.rbellogger.facets.sicct.SicctMessageType;
import de.gematik.rbellogger.util.RbelContent;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"sicct"})
public class RbelSicctEnvelopeConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelSicctEnvelopeConverter.class);
    private static final int ENVELOPE_LENGTH = 10;

    @Override
    public void consumeElement(RbelElement element, RbelConversionExecutor context) {
        if (element.getParentNode() != null || element.hasFacet(RbelHttpMessageFacet.class) || element.getSize() < 11L) {
            return;
        }
        try {
            RbelSicctEnvelopeFacet envelopeFacet = this.buildEnvelopeFacet(element);
            element.addFacet(envelopeFacet);
            context.convertElement(envelopeFacet.getCommand());
            envelopeFacet.getMessageType().seekValue(SicctMessageType.class).ifPresent(msgType -> {
                if (msgType == SicctMessageType.C_COMMAND) {
                    element.findMessage().addFacet(new RbelRequestFacet(this.requestInfoString(envelopeFacet), false));
                } else {
                    element.findMessage().addFacet(new RbelResponseFacet(Hex.toHexString((byte[])element.getContent().toByteArray((int)element.getSize() - 2, (int)element.getSize()))));
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private String requestInfoString(RbelSicctEnvelopeFacet envelopeFacet) {
        return envelopeFacet.getCommand().getFacet(RbelSicctCommandFacet.class).map(RbelSicctCommandFacet::getHeader).flatMap(el -> el.getFacet(RbelSicctHeaderFacet.class)).map(RbelSicctHeaderFacet::getCommand).map(Objects::toString).orElse("");
    }

    private RbelSicctEnvelopeFacet buildEnvelopeFacet(RbelElement element) {
        RbelContent content = element.getContent();
        byte[] lengthContent = content.toByteArray(6, 10);
        int length = ByteBuffer.wrap(lengthContent).getInt();
        RbelElement commandElement = new RbelElement(null, content.subArray(10, length + 10), element, Optional.empty());
        element.setUsedBytes(length + 10);
        commandElement.addFacet(new RbelBinaryFacet());
        return RbelSicctEnvelopeFacet.builder().messageType(RbelElement.wrap(new byte[]{content.get(0)}, element, (Object)SicctMessageType.of(content.get(0)))).srcOrDesAddress(new RbelElement(content.toByteArray(1, 3), element)).sequenceNumber(new RbelElement(content.toByteArray(3, 5), element)).abRfu(new RbelElement(content.toByteArray(5, 6), element)).length(new RbelElement(content.toByteArray(6, 10), element)).command(commandElement).build();
    }
}

