/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki.ocsp;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.facets.asn1.RbelAsn1OidFacet;
import de.gematik.rbellogger.facets.pki.AbstractX509FacetRenderer;
import de.gematik.rbellogger.facets.pki.ocsp.RbelSingleOcspResponseFacet;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H2Tag;
import java.util.Optional;
import lombok.Generated;

public class RbelOcspResponseFacet
implements RbelFacet {
    private RbelElement responseStatus;
    private RbelElement version;
    private RbelElement responderId;
    private RbelElement producedAt;
    private RbelElement responses;
    private RbelElement signature;
    private RbelElement signatureAlgorithm;
    private RbelElement certs;
    private RbelElement extensions;

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().with("responseStatus", this.responseStatus).with("version", this.version).with("responderId", this.responderId).with("producedAt", this.producedAt).with("responses", this.responses).with("signatureAlgorithm", this.signatureAlgorithm).with("signature", this.signature).with("certs", this.certs).with("extensions", this.extensions);
    }

    @Generated
    public RbelOcspResponseFacet() {
    }

    @Generated
    public RbelElement getResponseStatus() {
        return this.responseStatus;
    }

    @Generated
    public RbelElement getVersion() {
        return this.version;
    }

    @Generated
    public RbelElement getResponderId() {
        return this.responderId;
    }

    @Generated
    public RbelElement getProducedAt() {
        return this.producedAt;
    }

    @Generated
    public RbelElement getResponses() {
        return this.responses;
    }

    @Generated
    public RbelElement getSignature() {
        return this.signature;
    }

    @Generated
    public RbelElement getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Generated
    public RbelElement getCerts() {
        return this.certs;
    }

    @Generated
    public RbelElement getExtensions() {
        return this.extensions;
    }

    @Generated
    public void setResponseStatus(RbelElement responseStatus) {
        this.responseStatus = responseStatus;
    }

    @Generated
    public void setVersion(RbelElement version) {
        this.version = version;
    }

    @Generated
    public void setResponderId(RbelElement responderId) {
        this.responderId = responderId;
    }

    @Generated
    public void setProducedAt(RbelElement producedAt) {
        this.producedAt = producedAt;
    }

    @Generated
    public void setResponses(RbelElement responses) {
        this.responses = responses;
    }

    @Generated
    public void setSignature(RbelElement signature) {
        this.signature = signature;
    }

    @Generated
    public void setSignatureAlgorithm(RbelElement signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Generated
    public void setCerts(RbelElement certs) {
        this.certs = certs;
    }

    @Generated
    public void setExtensions(RbelElement extensions) {
        this.extensions = extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelOcspResponseFacet)) {
            return false;
        }
        RbelOcspResponseFacet other = (RbelOcspResponseFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$responseStatus = this.getResponseStatus();
        RbelElement other$responseStatus = other.getResponseStatus();
        if (this$responseStatus == null ? other$responseStatus != null : !this$responseStatus.equals(other$responseStatus)) {
            return false;
        }
        RbelElement this$version = this.getVersion();
        RbelElement other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        RbelElement this$responderId = this.getResponderId();
        RbelElement other$responderId = other.getResponderId();
        if (this$responderId == null ? other$responderId != null : !this$responderId.equals(other$responderId)) {
            return false;
        }
        RbelElement this$producedAt = this.getProducedAt();
        RbelElement other$producedAt = other.getProducedAt();
        if (this$producedAt == null ? other$producedAt != null : !this$producedAt.equals(other$producedAt)) {
            return false;
        }
        RbelElement this$responses = this.getResponses();
        RbelElement other$responses = other.getResponses();
        if (this$responses == null ? other$responses != null : !this$responses.equals(other$responses)) {
            return false;
        }
        RbelElement this$signature = this.getSignature();
        RbelElement other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        RbelElement this$signatureAlgorithm = this.getSignatureAlgorithm();
        RbelElement other$signatureAlgorithm = other.getSignatureAlgorithm();
        if (this$signatureAlgorithm == null ? other$signatureAlgorithm != null : !this$signatureAlgorithm.equals(other$signatureAlgorithm)) {
            return false;
        }
        RbelElement this$certs = this.getCerts();
        RbelElement other$certs = other.getCerts();
        if (this$certs == null ? other$certs != null : !this$certs.equals(other$certs)) {
            return false;
        }
        RbelElement this$extensions = this.getExtensions();
        RbelElement other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !this$extensions.equals(other$extensions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelOcspResponseFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $responseStatus = this.getResponseStatus();
        result = result * 59 + ($responseStatus == null ? 43 : $responseStatus.hashCode());
        RbelElement $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        RbelElement $responderId = this.getResponderId();
        result = result * 59 + ($responderId == null ? 43 : $responderId.hashCode());
        RbelElement $producedAt = this.getProducedAt();
        result = result * 59 + ($producedAt == null ? 43 : $producedAt.hashCode());
        RbelElement $responses = this.getResponses();
        result = result * 59 + ($responses == null ? 43 : $responses.hashCode());
        RbelElement $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        RbelElement $signatureAlgorithm = this.getSignatureAlgorithm();
        result = result * 59 + ($signatureAlgorithm == null ? 43 : $signatureAlgorithm.hashCode());
        RbelElement $certs = this.getCerts();
        result = result * 59 + ($certs == null ? 43 : $certs.hashCode());
        RbelElement $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : $extensions.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelOcspResponseFacet(responseStatus=" + String.valueOf(this.getResponseStatus()) + ", version=" + String.valueOf(this.getVersion()) + ", responderId=" + String.valueOf(this.getResponderId()) + ", producedAt=" + String.valueOf(this.getProducedAt()) + ", responses=" + String.valueOf(this.getResponses()) + ", signature=" + String.valueOf(this.getSignature()) + ", signatureAlgorithm=" + String.valueOf(this.getSignatureAlgorithm()) + ", certs=" + String.valueOf(this.getCerts()) + ", extensions=" + String.valueOf(this.getExtensions()) + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new AbstractX509FacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelOcspResponseFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                RbelOcspResponseFacet ocspResponseFacet = element.getFacetOrFail(RbelOcspResponseFacet.class);
                return ((DivTag)TagCreator.div((DomContent[])new DomContent[]{((H2Tag)TagCreator.h2().withClass("title")).withText("OCSP Response"), this.retrieveAndPrintValueNullSafe("Status: ", ocspResponseFacet.getResponseStatus()), this.retrieveAndPrintValueNullSafe("Version: ", ocspResponseFacet.getVersion()), this.retrieveAndPrintValueNullSafe("Responder ID: ", ocspResponseFacet.getResponderId()), this.retrieveAndPrintValueNullSafe("Produced at: ", ocspResponseFacet.getProducedAt()), this.retrieveAndPrintValueNullSafe("Signature algorithm: ", ocspResponseFacet.getSignatureAlgorithm().getFacet(RbelAsn1OidFacet.class).map(RbelAsn1OidFacet::getName).orElse(null)), TagCreator.br()}).with(ocspResponseFacet.getResponses().getChildNodes().stream().map(c -> renderingToolkit.generateSubsection("Single Response", (RbelElement)c, (ContainerTag<?>)this.renderSingleOcspResponse((RbelElement)c, renderingToolkit))).toList())).with(ocspResponseFacet.getExtensions().getChildNodes().stream().map(ext -> this.renderX509Extension((RbelElement)ext, renderingToolkit)).toList());
            }

            public ContainerTag renderSingleOcspResponse(RbelElement element, RbelHtmlRenderingToolkit renderingToolkit) {
                RbelSingleOcspResponseFacet singleOcspResponseFacet = element.getFacetOrFail(RbelSingleOcspResponseFacet.class);
                return TagCreator.div((DomContent[])new DomContent[]{((H2Tag)TagCreator.h2().withClass("title")).withText("Single Response"), this.retrieveAndPrintValueNullSafe("Issuer Name Hash: ", singleOcspResponseFacet.getIssuerNameHash()), this.retrieveAndPrintValueNullSafe("Issuer Key Hash: ", singleOcspResponseFacet.getIssuerKeyHash()), this.retrieveAndPrintValueNullSafe("Serial Number: ", singleOcspResponseFacet.getSerialNumber()), this.retrieveAndPrintValueNullSafe("Certificate Status: ", singleOcspResponseFacet.getCertStatus()), this.retrieveAndPrintValueNullSafe("This Update: ", singleOcspResponseFacet.getThisUpdate()), this.retrieveAndPrintValueNullSafe("Next Update: ", singleOcspResponseFacet.getNextUpdate()), TagCreator.br()}).with(singleOcspResponseFacet.getExtensions().getChildNodes().stream().map(ext -> this.renderX509Extension((RbelElement)ext, renderingToolkit)).toList());
            }
        });
    }
}

