/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki.ocsp;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelListFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.facets.pki.AbstractX509Converter;
import de.gematik.rbellogger.facets.pki.OidDictionary;
import de.gematik.rbellogger.facets.pki.ocsp.RbelOcspResponseFacet;
import de.gematik.rbellogger.facets.pki.ocsp.RbelSingleOcspResponseFacet;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"OCSP"})
public class RbelOcspResponseConverter
extends AbstractX509Converter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelOcspResponseConverter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConversionExecutor context) {
        if (!this.tryConversion(element, context, element::getRawContent) && !this.tryConversion(element, context, () -> Base64.getDecoder().decode(element.getRawContent()))) {
            this.tryConversion(element, context, () -> Base64.getUrlDecoder().decode(element.getRawContent()));
        }
    }

    private boolean tryConversion(RbelElement element, RbelConversionExecutor context, Supplier<byte[]> binaryContentExtractor) {
        try {
            OCSPResp ocspResponse = new OCSPResp(binaryContentExtractor.get());
            RbelOcspResponseFacet ocspResponseFacet = new RbelOcspResponseFacet();
            int status = ocspResponse.getStatus();
            ocspResponseFacet.setResponseStatus(RbelElement.wrap(element, status));
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
            this.executeSafe(() -> ocspResponseFacet.setVersion(RbelElement.wrap(element, basicResponse.getVersion())));
            this.executeSafe(() -> ocspResponseFacet.setResponderId(RbelElement.wrap(element, basicResponse.getResponderId().toASN1Primitive().getName().toString())));
            ocspResponseFacet.setSignatureAlgorithm(OidDictionary.buildAndAddAsn1OidFacet(RbelElement.wrap(element, basicResponse.getSignatureAlgOID().getId())));
            this.executeSafe(() -> ocspResponseFacet.setProducedAt(RbelElement.wrap(element, LocalDateTime.ofInstant(basicResponse.getProducedAt().toInstant(), ZoneId.systemDefault()))));
            this.executeSafe(() -> ocspResponseFacet.setResponses(RbelListFacet.wrap(element, el -> Stream.of(basicResponse.getResponses()).map(singleResp -> this.buildSingleResponseElement((SingleResp)singleResp, (RbelElement)el, context)).toList(), null)));
            this.executeSafe(() -> ocspResponseFacet.setExtensions(RbelListFacet.wrap(element, listElement -> basicResponse.getExtensionOIDs().stream().filter(ASN1ObjectIdentifier.class::isInstance).map(oid -> basicResponse.getExtension((ASN1ObjectIdentifier)oid)).map(ex -> this.parseExtension((Extension)ex, (RbelElement)listElement, context)).toList(), null)));
            element.addFacet(ocspResponseFacet);
            element.addFacet(new RbelRootFacet<RbelOcspResponseFacet>(ocspResponseFacet));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private RbelElement buildSingleResponseElement(SingleResp response, RbelElement parentElement, RbelConversionExecutor context) {
        RbelElement result = new RbelElement(null, parentElement);
        RbelSingleOcspResponseFacet responseFacet = new RbelSingleOcspResponseFacet();
        result.addFacet(responseFacet);
        result.addFacet(new RbelRootFacet<RbelSingleOcspResponseFacet>(responseFacet));
        this.executeSafe(() -> responseFacet.setHashAlgorithm(RbelElement.wrap(result, response.getCertID().getHashAlgOID().getId())));
        this.executeSafe(() -> responseFacet.setIssuerNameHash(RbelElement.wrap(result, Hex.toHexString((byte[])response.getCertID().getIssuerNameHash()).toUpperCase())));
        this.executeSafe(() -> responseFacet.setIssuerKeyHash(RbelElement.wrap(result, Hex.toHexString((byte[])response.getCertID().getIssuerKeyHash()).toUpperCase())));
        this.executeSafe(() -> responseFacet.setSerialNumber(RbelElement.wrap(result, response.getCertID().getSerialNumber().toString(16).toUpperCase())));
        this.executeSafe(() -> responseFacet.setCertStatus(RbelElement.wrap(result, response.getCertStatus().toString())));
        this.executeSafe(() -> responseFacet.setExtensions(RbelListFacet.wrap(result, listElement -> response.getExtensionOIDs().stream().filter(ASN1ObjectIdentifier.class::isInstance).map(oid -> response.getExtension((ASN1ObjectIdentifier)oid)).map(ex -> this.parseExtension((Extension)ex, (RbelElement)listElement, context)).toList(), null)));
        return result;
    }

    private void executeSafe(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            log.trace("Error while executing runnable", (Throwable)e);
        }
    }
}

