/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki.base64;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.facets.pki.base64.RbelBase64Facet;
import de.gematik.rbellogger.facets.xml.RbelXmlFacet;
import de.gematik.rbellogger.util.RbelContent;
import java.util.Base64;
import java.util.Optional;

public class RbelBase64JsonConverter
extends RbelConverterPlugin {
    @Override
    public void consumeElement(RbelElement rbel, RbelConversionExecutor context) {
        if (rbel.getSize() == 0L || rbel.hasFacet(RbelRootFacet.class)) {
            return;
        }
        RbelContent content = rbel.getContent();
        this.safeConvertBase64Using(Base64.getDecoder(), content, context, rbel).or(() -> this.safeConvertBase64Using(Base64.getUrlDecoder(), content, context, rbel)).ifPresent(rbel::addFacet);
    }

    private Optional<RbelBase64Facet> safeConvertBase64Using(Base64.Decoder decoder, RbelContent input, RbelConversionExecutor context, RbelElement parentNode) {
        RbelRootFacet rootFacet;
        Optional<RbelElement> rawElement = Optional.ofNullable(input).map(i -> {
            try {
                return RbelContent.from(decoder.wrap(input.toInputStream()));
            }
            catch (Exception e) {
                return null;
            }
        }).map(data -> RbelElement.builder().content((RbelContent)data).parentNode(parentNode).build());
        if (rawElement.isEmpty()) {
            return Optional.empty();
        }
        context.convertElement(rawElement.get());
        if (rawElement.get().hasFacet(RbelRootFacet.class) && ((rootFacet = rawElement.get().getFacetOrFail(RbelRootFacet.class)).getRootFacet() instanceof RbelJsonFacet || rootFacet.getRootFacet() instanceof RbelXmlFacet)) {
            return Optional.of(new RbelBase64Facet(rawElement.get()));
        }
        return Optional.empty();
    }
}

