/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki.base64;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.pki.base64.RbelB64GzipFacet;
import de.gematik.rbellogger.util.RbelContent;
import java.io.InputStream;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"b64gzip"})
public class RbelB64GzipConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelB64GzipConverter.class);
    private final byte[] b64GzipPrefix = "H4s".getBytes();

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        boolean potentiallyB64Gzip = rbelElement.getContent().startsWith(this.b64GzipPrefix);
        if (!potentiallyB64Gzip) {
            return;
        }
        this.parseB64GzippedMessage(rbelElement, converter);
    }

    private void parseB64GzippedMessage(RbelElement parentElement, RbelConversionExecutor converter) {
        try {
            InputStream gzipped = Base64.getDecoder().wrap(parentElement.getContent().toInputStream());
            GZIPInputStream gis = new GZIPInputStream(gzipped);
            RbelContent unzipped = RbelContent.from(gis);
            RbelElement unzippedElement = converter.convertElement(unzipped, parentElement);
            RbelB64GzipFacet rbelB64GzipFacet = new RbelB64GzipFacet(unzippedElement);
            parentElement.addFacet(rbelB64GzipFacet);
        }
        catch (Exception e) {
            throw new RbelConversionException(e, parentElement, (RbelConverterPlugin)this);
        }
    }
}

