/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelBinaryFacet;
import de.gematik.rbellogger.data.core.RbelListFacet;
import de.gematik.rbellogger.data.core.RbelMapFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.pki.AbstractX509Converter;
import de.gematik.rbellogger.facets.pki.OidDictionary;
import de.gematik.rbellogger.facets.pki.RbelX509CertificateFacet;
import de.gematik.rbellogger.util.CryptoLoader;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"X509"})
public class RbelX509Converter
extends AbstractX509Converter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelX509Converter.class);
    private static final ZoneId utcZone = ZoneId.of("UTC");

    @Override
    public void consumeElement(RbelElement element, RbelConversionExecutor context) {
        if (element.hasFacet(RbelX509CertificateFacet.class)) {
            return;
        }
        if (!this.tryConversion(element, context, () -> element.getContent().toInputStream()) && !this.tryConversion(element, context, () -> Base64.getDecoder().wrap(element.getContent().toInputStream()))) {
            this.tryConversion(element, context, () -> Base64.getUrlDecoder().wrap(element.getContent().toInputStream()));
        }
    }

    private boolean tryConversion(RbelElement element, RbelConversionExecutor context, Supplier<InputStream> binaryContentExtractor) {
        try {
            X509Certificate certificate = CryptoLoader.getCertificateFromPem((InputStream)binaryContentExtractor.get());
            RbelX509CertificateFacet x509Facet = RbelX509CertificateFacet.builder().version(certificate.getVersion()).serialnumber(certificate.getSerialNumber()).issuer(context.convertElement(certificate.getIssuerX500Principal().getEncoded(), element)).validFrom(ZonedDateTime.ofInstant(certificate.getNotBefore().toInstant(), utcZone)).validUntil(ZonedDateTime.ofInstant(certificate.getNotAfter().toInstant(), utcZone)).subject(context.convertElement(certificate.getSubjectX500Principal().getEncoded(), element)).subjectPublicKeyInfo(RbelMapFacet.wrap(element, el -> {
                RbelMultiMap<RbelElement> elementMap = new RbelMultiMap<RbelElement>().with("algorithm", RbelElement.wrap(el, certificate.getPublicKey().getAlgorithm())).with("format", RbelElement.wrap(el, certificate.getPublicKey().getFormat())).with("encoded", new RbelElement(certificate.getPublicKey().getEncoded(), (RbelElement)el).addFacet(new RbelBinaryFacet()));
                this.addKeyParameters(certificate.getPublicKey(), elementMap, (RbelElement)el);
                return elementMap;
            }, null)).extensions(this.parseCertificateExtensions(element, context, certificate)).signature(this.buildSignatureInfo(element, certificate)).parent(element).certificate(certificate).build();
            element.addFacet(x509Facet);
            element.addFacet(new RbelRootFacet<RbelX509CertificateFacet>(x509Facet));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private void addKeyParameters(PublicKey publicKey, RbelMultiMap<RbelElement> rbelElementMap, RbelElement parentNode) {
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            ECParameterSpec eCParameterSpec = ecPublicKey.getParams();
            if (eCParameterSpec instanceof ECNamedCurveSpec) {
                ECNamedCurveSpec ecNamedCurveSpec = (ECNamedCurveSpec)eCParameterSpec;
                rbelElementMap.with("curve", RbelElement.wrap(parentNode, ecNamedCurveSpec.getName()));
            } else {
                rbelElementMap.with("curve", RbelElement.wrap(parentNode, "<unknown>"));
            }
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            rbelElementMap.with("modulusLength", RbelElement.wrap(parentNode, rsaPublicKey.getModulus().bitLength()));
        }
    }

    private RbelElement buildSignatureInfo(RbelElement element, X509Certificate certificate) {
        return RbelMapFacet.wrap(element, el -> {
            RbelElement oid = RbelElement.wrap(el, certificate.getSigAlgOID());
            OidDictionary.buildAndAddAsn1OidFacet(oid, certificate.getSigAlgOID());
            return new RbelMultiMap<RbelElement>().with("algorithm", oid).with("encoded", new RbelElement(certificate.getSignature(), (RbelElement)el).addFacet(new RbelBinaryFacet()));
        }, certificate.getSignature());
    }

    public RbelElement parseCertificateExtensions(RbelElement parent, RbelConversionExecutor context, X509Certificate certificate) {
        return RbelListFacet.wrap(parent, el -> this.streamOfAllExtensions(certificate).map(ex -> this.parseExtension((Extension)ex, (RbelElement)el, context)).toList(), null);
    }

    private Stream<Extension> streamOfAllExtensions(X509Certificate certificate) {
        return Stream.concat(certificate.getCriticalExtensionOIDs().stream().map(oid -> RbelX509Converter.buildExtension(certificate, oid, true)), certificate.getNonCriticalExtensionOIDs().stream().map(oid -> RbelX509Converter.buildExtension(certificate, oid, false)));
    }

    private static Extension buildExtension(X509Certificate certificate, String oid, boolean critical) {
        try {
            return Extension.create((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(oid), (boolean)critical, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])certificate.getExtensionValue(oid)));
        }
        catch (IOException e) {
            throw new RbelConversionException(e);
        }
    }
}

