/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.data.core.RbelMapFacet;
import de.gematik.rbellogger.facets.pki.AbstractX509FacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H2Tag;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class RbelX509CertificateFacet
implements RbelFacet {
    private final RbelElement version;
    private final RbelElement serialnumber;
    private final RbelElement issuer;
    private final RbelElement validFrom;
    private final RbelElement validUntil;
    private final RbelElement subject;
    private final RbelElement subjectPublicKeyInfo;
    private final RbelElement extensions;
    private final RbelElement signature;
    private final X509Certificate certificate;

    private RbelX509CertificateFacet(RbelElement parent, BigInteger serialnumber, RbelElement issuer, ZonedDateTime validFrom, ZonedDateTime validUntil, RbelElement subject, RbelElement subjectPublicKeyInfo, RbelElement extensions, RbelElement signature, X509Certificate certificate, int version) {
        this.version = RbelElement.wrap(parent, version);
        this.serialnumber = RbelElement.wrap(parent, serialnumber);
        this.issuer = issuer;
        this.validFrom = RbelElement.wrap(parent, validFrom);
        this.validUntil = RbelElement.wrap(parent, validUntil);
        this.subject = subject;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.extensions = extensions;
        this.signature = signature;
        this.certificate = certificate;
    }

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().with("version", this.version).with("serialnumber", this.serialnumber).with("issuer", this.issuer).with("validFrom", this.validFrom).with("validUntil", this.validUntil).with("subject", this.subject).with("subjectPublicKeyInfo", this.subjectPublicKeyInfo).with("extensions", this.extensions).with("signature", this.signature);
    }

    @Generated
    public static RbelX509CertificateFacetBuilder builder() {
        return new RbelX509CertificateFacetBuilder();
    }

    @Generated
    public RbelElement getVersion() {
        return this.version;
    }

    @Generated
    public RbelElement getSerialnumber() {
        return this.serialnumber;
    }

    @Generated
    public RbelElement getIssuer() {
        return this.issuer;
    }

    @Generated
    public RbelElement getValidFrom() {
        return this.validFrom;
    }

    @Generated
    public RbelElement getValidUntil() {
        return this.validUntil;
    }

    @Generated
    public RbelElement getSubject() {
        return this.subject;
    }

    @Generated
    public RbelElement getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    @Generated
    public RbelElement getExtensions() {
        return this.extensions;
    }

    @Generated
    public RbelElement getSignature() {
        return this.signature;
    }

    @Generated
    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelX509CertificateFacet)) {
            return false;
        }
        RbelX509CertificateFacet other = (RbelX509CertificateFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$version = this.getVersion();
        RbelElement other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        RbelElement this$serialnumber = this.getSerialnumber();
        RbelElement other$serialnumber = other.getSerialnumber();
        if (this$serialnumber == null ? other$serialnumber != null : !this$serialnumber.equals(other$serialnumber)) {
            return false;
        }
        RbelElement this$issuer = this.getIssuer();
        RbelElement other$issuer = other.getIssuer();
        if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
            return false;
        }
        RbelElement this$validFrom = this.getValidFrom();
        RbelElement other$validFrom = other.getValidFrom();
        if (this$validFrom == null ? other$validFrom != null : !this$validFrom.equals(other$validFrom)) {
            return false;
        }
        RbelElement this$validUntil = this.getValidUntil();
        RbelElement other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) {
            return false;
        }
        RbelElement this$subject = this.getSubject();
        RbelElement other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        RbelElement this$subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        RbelElement other$subjectPublicKeyInfo = other.getSubjectPublicKeyInfo();
        if (this$subjectPublicKeyInfo == null ? other$subjectPublicKeyInfo != null : !this$subjectPublicKeyInfo.equals(other$subjectPublicKeyInfo)) {
            return false;
        }
        RbelElement this$extensions = this.getExtensions();
        RbelElement other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !this$extensions.equals(other$extensions)) {
            return false;
        }
        RbelElement this$signature = this.getSignature();
        RbelElement other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        X509Certificate this$certificate = this.getCertificate();
        X509Certificate other$certificate = other.getCertificate();
        return !(this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelX509CertificateFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        RbelElement $serialnumber = this.getSerialnumber();
        result = result * 59 + ($serialnumber == null ? 43 : $serialnumber.hashCode());
        RbelElement $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
        RbelElement $validFrom = this.getValidFrom();
        result = result * 59 + ($validFrom == null ? 43 : $validFrom.hashCode());
        RbelElement $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : $validUntil.hashCode());
        RbelElement $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        RbelElement $subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        result = result * 59 + ($subjectPublicKeyInfo == null ? 43 : $subjectPublicKeyInfo.hashCode());
        RbelElement $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : $extensions.hashCode());
        RbelElement $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        X509Certificate $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelX509CertificateFacet(version=" + String.valueOf(this.getVersion()) + ", serialnumber=" + String.valueOf(this.getSerialnumber()) + ", issuer=" + String.valueOf(this.getIssuer()) + ", validFrom=" + String.valueOf(this.getValidFrom()) + ", validUntil=" + String.valueOf(this.getValidUntil()) + ", subject=" + String.valueOf(this.getSubject()) + ", subjectPublicKeyInfo=" + String.valueOf(this.getSubjectPublicKeyInfo()) + ", extensions=" + String.valueOf(this.getExtensions()) + ", signature=" + String.valueOf(this.getSignature()) + ", certificate=" + String.valueOf(this.getCertificate()) + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new AbstractX509FacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelX509CertificateFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                RbelX509CertificateFacet x509Facet = element.getFacetOrFail(RbelX509CertificateFacet.class);
                return ((DivTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{((H2Tag)TagCreator.h2().withClass("title")).withText("X509 Certificate"), this.retrieveAndPrintValueNullSafe("Subject: ", x509Facet.getSubject()), this.retrieveAndPrintValueNullSafe("Issuer: ", x509Facet.getIssuer()), this.retrieveAndPrintValueNullSafe("Serialnumber: ", x509Facet.getSerialnumber()), this.retrieveAndPrintValueNullSafe("Valid From: ", x509Facet.getValidFrom()), this.retrieveAndPrintValueNullSafe("Valid Until: ", x509Facet.getValidUntil()), TagCreator.br()}).with((Iterable)x509Facet.getSubjectPublicKeyInfo().getFacet(RbelMapFacet.class).map(RbelMapFacet::getChildNodes).map(this::printPublicKeyInfo).orElse(List.of()))).with(x509Facet.getExtensions().getChildNodes().stream().map(ext -> this.renderX509Extension((RbelElement)ext, renderingToolkit)).toList())).with((DomContent)RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with(renderingToolkit.convertNested(element))));
            }

            private List<DomContent> printPublicKeyInfo(RbelMultiMap<RbelElement> infoMap) {
                return this.renderValueChildren(infoMap);
            }
        });
    }

    @Generated
    public static class RbelX509CertificateFacetBuilder {
        @Generated
        private RbelElement parent;
        @Generated
        private BigInteger serialnumber;
        @Generated
        private RbelElement issuer;
        @Generated
        private ZonedDateTime validFrom;
        @Generated
        private ZonedDateTime validUntil;
        @Generated
        private RbelElement subject;
        @Generated
        private RbelElement subjectPublicKeyInfo;
        @Generated
        private RbelElement extensions;
        @Generated
        private RbelElement signature;
        @Generated
        private X509Certificate certificate;
        @Generated
        private int version;

        @Generated
        RbelX509CertificateFacetBuilder() {
        }

        @Generated
        public RbelX509CertificateFacetBuilder parent(RbelElement parent) {
            this.parent = parent;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder serialnumber(BigInteger serialnumber) {
            this.serialnumber = serialnumber;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder issuer(RbelElement issuer) {
            this.issuer = issuer;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder validFrom(ZonedDateTime validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder validUntil(ZonedDateTime validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder subject(RbelElement subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder subjectPublicKeyInfo(RbelElement subjectPublicKeyInfo) {
            this.subjectPublicKeyInfo = subjectPublicKeyInfo;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder extensions(RbelElement extensions) {
            this.extensions = extensions;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder signature(RbelElement signature) {
            this.signature = signature;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder certificate(X509Certificate certificate) {
            this.certificate = certificate;
            return this;
        }

        @Generated
        public RbelX509CertificateFacetBuilder version(int version) {
            this.version = version;
            return this;
        }

        @Generated
        public RbelX509CertificateFacet build() {
            return new RbelX509CertificateFacet(this.parent, this.serialnumber, this.issuer, this.validFrom, this.validUntil, this.subject, this.subjectPublicKeyInfo, this.extensions, this.signature, this.certificate, this.version);
        }

        @Generated
        public String toString() {
            return "RbelX509CertificateFacet.RbelX509CertificateFacetBuilder(parent=" + String.valueOf(this.parent) + ", serialnumber=" + String.valueOf(this.serialnumber) + ", issuer=" + String.valueOf(this.issuer) + ", validFrom=" + String.valueOf(this.validFrom) + ", validUntil=" + String.valueOf(this.validUntil) + ", subject=" + String.valueOf(this.subject) + ", subjectPublicKeyInfo=" + String.valueOf(this.subjectPublicKeyInfo) + ", extensions=" + String.valueOf(this.extensions) + ", signature=" + String.valueOf(this.signature) + ", certificate=" + String.valueOf(this.certificate) + ", version=" + this.version + ")";
        }
    }
}

