/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelMapFacet;
import de.gematik.rbellogger.data.core.RbelValueFacet;
import de.gematik.rbellogger.facets.asn1.RbelAsn1Facet;
import java.io.IOException;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.style.X500NameTokenizer;
import org.bouncycastle.asn1.x509.X509Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"X500", "ASN1", "X509"})
public class RbelX500Converter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelX500Converter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConversionExecutor context) {
        if (element.hasFacet(RbelAsn1Facet.class)) {
            element.getFacet(RbelAsn1Facet.class).map(RbelAsn1Facet::getAsn1Content).filter(ASN1Sequence.class::isInstance).map(ASN1Sequence.class::cast).ifPresent(sequence -> this.convertAsn1Sequence((ASN1Sequence)sequence, element, context));
        } else {
            if (!element.getFacets().isEmpty()) {
                return;
            }
            try (ASN1InputStream asnInput = new ASN1InputStream(element.getContent().toInputStream());){
                this.convertAsn1Sequence(ASN1Sequence.getInstance((Object)asnInput.readObject()), element, context);
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        }
    }

    private void convertAsn1Sequence(ASN1Sequence sequence, RbelElement element, RbelConversionExecutor context) {
        try {
            String principal = new X509Name(sequence).toString();
            X500NameTokenizer nameTokenizer = new X500NameTokenizer(principal);
            RbelMultiMap<RbelElement> rdnMap = new RbelMultiMap<RbelElement>();
            while (nameTokenizer.hasMoreTokens()) {
                String[] token = nameTokenizer.nextToken().split("=");
                rdnMap.put(token[0], context.convertElement(token[1], element));
            }
            if (!rdnMap.isEmpty()) {
                element.addFacet(new RbelMapFacet(rdnMap));
                element.addFacet(RbelValueFacet.of(principal));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

