/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.facets.asn1.RbelAsn1Converter;
import de.gematik.rbellogger.facets.asn1.RbelAsn1OidFacet;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class OidDictionary {
    private static final Map<String, String> OID_DICTIONARY;

    public static void buildAndAddAsn1OidFacet(RbelElement parentNode, String id) {
        String humanReadableName = OID_DICTIONARY.get(id);
        if (humanReadableName != null) {
            parentNode.addFacet(new RbelAsn1OidFacet(RbelElement.wrap(parentNode, humanReadableName)));
        }
    }

    public static RbelElement buildAndAddAsn1OidFacet(RbelElement parentNode) {
        parentNode.printValue().map(OID_DICTIONARY::get).ifPresent(name -> parentNode.addFacet(new RbelAsn1OidFacet(RbelElement.wrap(parentNode, name))));
        return parentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<String, String> map = OID_DICTIONARY = new HashMap<String, String>();
        synchronized (map) {
            try (InputStream is = RbelAsn1Converter.class.getClassLoader().getResourceAsStream("ASN1Dictionary.xml");){
                if (is != null) {
                    Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
                    for (Element element : doc.select("oid")) {
                        String id = ((Element)element.select("dot").get(0)).text().trim();
                        String name = ((Element)element.select("desc").get(0)).text();
                        OID_DICTIONARY.put(id, name);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

