/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelValueFacet;
import de.gematik.rbellogger.facets.asn1.RbelAsn1ExtensionFacet;
import de.gematik.rbellogger.facets.asn1.RbelAsn1OidFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.PTag;
import java.util.List;
import lombok.Generated;

public abstract class AbstractX509FacetRenderer
implements RbelHtmlFacetRenderer {
    public DomContent retrieveAndPrintValueNullSafe(String text, RbelElement targetElement) {
        if (targetElement == null) {
            return TagCreator.text((String)"");
        }
        return ((PTag)((PTag)TagCreator.p().withClass("is-size-6")).with((DomContent)TagCreator.b().withText(text))).withText(targetElement.printValue().orElse(""));
    }

    public DomContent renderX509Extension(RbelElement element, RbelHtmlRenderingToolkit renderingToolkit) {
        RbelAsn1ExtensionFacet extensionFacet = element.getFacetOrFail(RbelAsn1ExtensionFacet.class);
        String id = extensionFacet.getOid().printValue().orElse("<Unknown OID>");
        String title = extensionFacet.getOid().getFacet(RbelAsn1OidFacet.class).map(RbelAsn1OidFacet::getName).flatMap(RbelElement::printValue).map(name -> name + " (" + id + ")").orElse(id);
        return renderingToolkit.generateSubsection(title, element, (ContainerTag<?>)TagCreator.div((DomContent[])new DomContent[]{this.retrieveAndPrintValueNullSafe("Critical: ", extensionFacet.getCritical()), TagCreator.br(), RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with(renderingToolkit.convertNested(element)))}));
    }

    protected List<DomContent> renderValueChildren(RbelMultiMap<RbelElement> infoMap) {
        return infoMap.stream().filter(pair -> ((RbelElement)pair.getValue()).hasFacet(RbelValueFacet.class)).map(pair -> this.retrieveAndPrintValueNullSafe((String)pair.getKey() + ": ", ((RbelElement)pair.getValue()).getFacet(RbelAsn1OidFacet.class).map(RbelAsn1OidFacet::getName).orElseGet(pair::getValue))).toList();
    }

    @Generated
    public AbstractX509FacetRenderer() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractX509FacetRenderer)) {
            return false;
        }
        AbstractX509FacetRenderer other = (AbstractX509FacetRenderer)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractX509FacetRenderer;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "AbstractX509FacetRenderer()";
    }
}

