/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.pki;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.facets.asn1.RbelAsn1Converter;
import de.gematik.rbellogger.facets.asn1.RbelAsn1ExtensionFacet;
import de.gematik.rbellogger.facets.pki.OidDictionary;
import lombok.Generated;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"OCSP"})
public abstract class AbstractX509Converter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractX509Converter.class);

    public RbelElement parseExtension(Extension ex, RbelElement parentElement, RbelConversionExecutor context) {
        RbelElement result = new RbelElement(ex.getEncoded(), parentElement);
        RbelElement extensionNestedElement = new RbelElement(ex.getParsedValue().toASN1Primitive().getEncoded(), result);
        String extensionOid = ex.getExtnId().getId();
        RbelElement oidElement = RbelElement.wrap(result, extensionOid);
        OidDictionary.buildAndAddAsn1OidFacet(oidElement, extensionOid);
        RbelAsn1ExtensionFacet extensionFacet = RbelAsn1ExtensionFacet.builder().value(extensionNestedElement).critical(RbelElement.wrap(result, ex.isCritical())).oid(oidElement).build();
        result.addFacet(extensionFacet);
        result.addFacet(new RbelRootFacet<RbelAsn1ExtensionFacet>(extensionFacet));
        result.addFacet(new RbelAsn1Converter.RbelAllowAsn1FragmentsFacet());
        context.convertElement(extensionNestedElement);
        result.removeFacetsOfType(RbelAsn1Converter.RbelAllowAsn1FragmentsFacet.class);
        return result;
    }
}

