/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.ldap;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.facets.ldap.RbelLdapAttributesFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.PreTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TrTag;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class RbelLdapFacet
implements RbelFacet {
    public static final String MSG_ID_KEY = "msgId";
    public static final String PROTOCOL_OP_KEY = "protocolOp";
    public static final String TEXT_REPRESENTATION_KEY = "textRepresentation";
    public static final String ATTRIBUTES_KEY = "attributes";
    private final RbelElement textRepresentation;
    private final RbelElement msgId;
    private final RbelElement protocolOp;
    private final RbelElement attributes;

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().with(TEXT_REPRESENTATION_KEY, this.textRepresentation).with(MSG_ID_KEY, this.msgId).with(PROTOCOL_OP_KEY, this.protocolOp).withSkipIfNull(ATTRIBUTES_KEY, this.attributes);
    }

    @Generated
    public static RbelLdapFacetBuilder builder() {
        return new RbelLdapFacetBuilder();
    }

    @Generated
    public RbelElement getTextRepresentation() {
        return this.textRepresentation;
    }

    @Generated
    public RbelElement getMsgId() {
        return this.msgId;
    }

    @Generated
    public RbelElement getProtocolOp() {
        return this.protocolOp;
    }

    @Generated
    public RbelElement getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelLdapFacet)) {
            return false;
        }
        RbelLdapFacet other = (RbelLdapFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$textRepresentation = this.getTextRepresentation();
        RbelElement other$textRepresentation = other.getTextRepresentation();
        if (this$textRepresentation == null ? other$textRepresentation != null : !this$textRepresentation.equals(other$textRepresentation)) {
            return false;
        }
        RbelElement this$msgId = this.getMsgId();
        RbelElement other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        RbelElement this$protocolOp = this.getProtocolOp();
        RbelElement other$protocolOp = other.getProtocolOp();
        if (this$protocolOp == null ? other$protocolOp != null : !this$protocolOp.equals(other$protocolOp)) {
            return false;
        }
        RbelElement this$attributes = this.getAttributes();
        RbelElement other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelLdapFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $textRepresentation = this.getTextRepresentation();
        result = result * 59 + ($textRepresentation == null ? 43 : $textRepresentation.hashCode());
        RbelElement $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        RbelElement $protocolOp = this.getProtocolOp();
        result = result * 59 + ($protocolOp == null ? 43 : $protocolOp.hashCode());
        RbelElement $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelLdapFacet(textRepresentation=" + String.valueOf(this.getTextRepresentation()) + ", msgId=" + String.valueOf(this.getMsgId()) + ", protocolOp=" + String.valueOf(this.getProtocolOp()) + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    @ConstructorProperties(value={"textRepresentation", "msgId", "protocolOp", "attributes"})
    @Generated
    public RbelLdapFacet(RbelElement textRepresentation, RbelElement msgId, RbelElement protocolOp, RbelElement attributes) {
        this.textRepresentation = textRepresentation;
        this.msgId = msgId;
        this.protocolOp = protocolOp;
        this.attributes = attributes;
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelLdapFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                RbelElement attributesElement;
                RbelLdapFacet facet = element.getFacetOrFail(RbelLdapFacet.class);
                String messageId = facet.getChildElements().get(RbelLdapFacet.MSG_ID_KEY).getRawStringContent();
                String protocolOperation = facet.getChildElements().get(RbelLdapFacet.PROTOCOL_OP_KEY).getRawStringContent();
                LinkedHashMap<Object, String> attributesMap = new LinkedHashMap<Object, String>();
                attributesMap.put("Message ID", messageId);
                attributesMap.put("Operation", protocolOperation);
                if (facet.getChildElements().containsKey(RbelLdapFacet.ATTRIBUTES_KEY) && (attributesElement = facet.getChildElements().get(RbelLdapFacet.ATTRIBUTES_KEY)) != null && attributesElement.hasFacet(RbelLdapAttributesFacet.class)) {
                    RbelLdapAttributesFacet attributesFacet = attributesElement.getFacetOrFail(RbelLdapAttributesFacet.class);
                    for (Map.Entry attribute : attributesFacet.entries()) {
                        String attributeName = "Attribute: " + attribute.getKey();
                        String value = ((RbelElement)attribute.getValue()).getRawStringContent();
                        attributesMap.computeIfPresent(attributeName, (k, v) -> v + ", " + value);
                        attributesMap.putIfAbsent(attributeName, value);
                    }
                }
                ArrayList<TrTag> tableRows = new ArrayList<TrTag>();
                for (Map.Entry entry : attributesMap.entrySet()) {
                    tableRows.add(TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{((PreTag)TagCreator.pre().withText((String)entry.getKey())).withClass("key")}), TagCreator.td((DomContent[])new DomContent[]{((PreTag)TagCreator.pre().withText((String)entry.getValue())).withClass("value")})}));
                }
                ContainerTag table = ((TableTag)TagCreator.table().withClass("table")).with((DomContent)TagCreator.tbody().with(tableRows));
                return RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with((DomContent)((DivTag)((DivTag)((DivTag)TagCreator.div().withClass("tile is-child pe-2")).with((DomContent)TagCreator.pre((String)"LDAP message").withClass("json language-json"))).with((DomContent)table)).with(renderingToolkit.convertNested(element))));
            }
        });
    }

    @Generated
    public static class RbelLdapFacetBuilder {
        @Generated
        private RbelElement textRepresentation;
        @Generated
        private RbelElement msgId;
        @Generated
        private RbelElement protocolOp;
        @Generated
        private RbelElement attributes;

        @Generated
        RbelLdapFacetBuilder() {
        }

        @Generated
        public RbelLdapFacetBuilder textRepresentation(RbelElement textRepresentation) {
            this.textRepresentation = textRepresentation;
            return this;
        }

        @Generated
        public RbelLdapFacetBuilder msgId(RbelElement msgId) {
            this.msgId = msgId;
            return this;
        }

        @Generated
        public RbelLdapFacetBuilder protocolOp(RbelElement protocolOp) {
            this.protocolOp = protocolOp;
            return this;
        }

        @Generated
        public RbelLdapFacetBuilder attributes(RbelElement attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public RbelLdapFacet build() {
            return new RbelLdapFacet(this.textRepresentation, this.msgId, this.protocolOp, this.attributes);
        }

        @Generated
        public String toString() {
            return "RbelLdapFacet.RbelLdapFacetBuilder(textRepresentation=" + String.valueOf(this.textRepresentation) + ", msgId=" + String.valueOf(this.msgId) + ", protocolOp=" + String.valueOf(this.protocolOp) + ", attributes=" + String.valueOf(this.attributes) + ")";
        }
    }
}

