/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.ldap;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPException;
import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.ldap.RbelLdapAttributesFacet;
import de.gematik.rbellogger.facets.ldap.RbelLdapFacet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(onlyActivateFor={"ldap"})
public class RbelLdapConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelLdapConverter.class);
    private final byte[] ldapMessagePrefix = new byte[]{48};

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        boolean potentiallyLdap = rbelElement.getContent().startsWith(this.ldapMessagePrefix);
        if (!potentiallyLdap) {
            return;
        }
        this.parseLdapMessage(rbelElement, converter);
    }

    private void parseLdapMessage(RbelElement rbelElement, RbelConversionExecutor converter) {
        try {
            ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(rbelElement.getRawContent()));
            byte[] data = asn1InputStream.readObject().getEncoded();
            ASN1Element asn1Element = ASN1Element.decode((byte[])data);
            LDAPMessage ldapMessage = LDAPMessage.decode((ASN1Element)asn1Element);
            RbelElement textRepresentationElement = this.extractBy(LDAPMessage::toString, ldapMessage, rbelElement, converter);
            RbelElement msgIdElement = this.extractBy(m -> Integer.toString(m.getMessageID()), ldapMessage, rbelElement, converter);
            RbelElement protocolOpElement = this.extractBy(this::getShortProtocolOpDesc, ldapMessage, rbelElement, converter);
            Optional<RbelElement> attributes = this.extractAttributes(ldapMessage, rbelElement, converter);
            RbelLdapFacet rbelLdapFacet = new RbelLdapFacet(textRepresentationElement, msgIdElement, protocolOpElement, attributes.orElse(null));
            rbelElement.addFacet(rbelLdapFacet);
            rbelElement.addFacet(new RbelRootFacet<RbelLdapFacet>(rbelLdapFacet));
            this.handleRequestResponse(rbelElement, ldapMessage);
        }
        catch (ASN1Exception | LDAPException | IOException e) {
            throw new RbelConversionException("Attempt to parse LDAP failed", (Exception)e, rbelElement, this);
        }
    }

    private String getShortProtocolOpDesc(LDAPMessage ldapMessage) {
        String fullProtocolOpDesc = ldapMessage.getProtocolOp().toString();
        if (fullProtocolOpDesc.contains("attrs=")) {
            return fullProtocolOpDesc.substring(0, fullProtocolOpDesc.indexOf(", attrs=")) + ")";
        }
        return fullProtocolOpDesc;
    }

    private void handleRequestResponse(RbelElement rbelElement, LDAPMessage ldapMessage) {
        String protocolOp = ldapMessage.getProtocolOp().getClass().getSimpleName();
        if (protocolOp.contains("Request")) {
            rbelElement.addFacet(new RbelRequestFacet(protocolOp, false));
        } else {
            rbelElement.addFacet(new RbelResponseFacet(protocolOp));
        }
    }

    private RbelElement extractBy(Function<LDAPMessage, String> extract, LDAPMessage ldapMessage, RbelElement parentElement, RbelConversionExecutor converter) {
        String value = extract.apply(ldapMessage);
        return converter.convertElement(value, parentElement);
    }

    private Optional<RbelElement> extractAttributes(LDAPMessage ldapMessage, RbelElement parentElement, RbelConversionExecutor converter) {
        RbelLdapAttributesFacet attributesFacet = new RbelLdapAttributesFacet();
        if (ldapMessage.getProtocolOp() instanceof SearchResultEntryProtocolOp) {
            SearchResultEntryProtocolOp op = ldapMessage.getSearchResultEntryProtocolOp();
            RbelElement result = new RbelElement(new byte[0], parentElement);
            for (Attribute attr : op.getAttributes()) {
                for (String value : attr.getValues()) {
                    attributesFacet.put(attr.getName(), converter.convertElement(value, result));
                }
            }
            result.addFacet(attributesFacet);
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

