/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.jose;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.util.CryptoLoader;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelX5cKeyReader
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelX5cKeyReader.class);

    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.CONTENT_ENRICHMENT;
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        List<RbelElement> elementList = rbelElement.findRbelPathMembers("$..x5c").stream().filter(el -> el.hasFacet(RbelJsonFacet.class)).toList();
        for (RbelElement x5cElement : elementList) {
            Optional<byte[]> certificateData = this.getX509Certificate(x5cElement);
            Optional<String> keyId = this.getKeyId(x5cElement);
            if (!keyId.isPresent() || !certificateData.isPresent()) continue;
            try {
                X509Certificate certificate = CryptoLoader.getCertificateFromPem((byte[])certificateData.get());
                converter.getRbelKeyManager().addKey(keyId.get(), certificate.getPublicKey(), 100).ifPresent(newKey -> log.info("Added new key from JKS ({})", (Object)newKey.getKeyName()));
            }
            catch (Exception e) {
                log.trace("Exception while extracting X5C", (Throwable)e);
            }
        }
    }

    private Optional<String> getKeyId(RbelElement x5cElement) {
        return Optional.ofNullable(x5cElement.getParentNode()).flatMap(el -> el.getFirst("kid")).flatMap(el -> el.getFirst("content")).map(RbelElement::getRawStringContent);
    }

    private Optional<byte[]> getX509Certificate(RbelElement x5cElement) {
        try {
            return x5cElement.getFirst("0").flatMap(el -> el.getFirst("content")).map(RbelElement::getRawStringContent).map(Base64.getDecoder()::decode);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

