/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.jose;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.facets.jose.RbelJwtFacet;
import de.gematik.rbellogger.facets.jose.RbelJwtSignature;
import de.gematik.rbellogger.facets.pki.base64.RbelBase64JsonConverter;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.jose4j.jca.ProviderContext;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(dependsOn={RbelBase64JsonConverter.class})
public class RbelJwtConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelJwtConverter.class);
    public static final int JWT_DOT_SEPARATOR_COUNT = 2;

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        int dotCount = rbelElement.getContent().countOccurrencesUpTo((byte)46, 3);
        if (dotCount != 2) {
            return;
        }
        this.parseJwt(rbelElement, converter);
    }

    private void parseJwt(RbelElement rbelElement, RbelConversionExecutor converter) {
        try {
            JsonWebSignature jsonWebSignature = this.initializeJws(rbelElement);
            RbelElement headerElement = converter.convertElement(jsonWebSignature.getHeaders().getFullHeaderAsJsonString().getBytes(StandardCharsets.UTF_8), rbelElement);
            RbelElement bodyElement = converter.convertElement(jsonWebSignature.getUnverifiedPayloadBytes(), rbelElement);
            RbelElement signatureElement = new RbelElement(Base64.getUrlDecoder().decode(jsonWebSignature.getEncodedSignature()), rbelElement);
            signatureElement.addFacet(converter.getRbelKeyManager().getAllKeys().map(rbelKey -> this.verifySig(jsonWebSignature, rbelKey.getKey(), rbelKey.getKeyName(), signatureElement)).filter(Optional::isPresent).map(Optional::get).findAny().or(() -> this.tryToGetKeyFromX5cHeaderClaim(jsonWebSignature).map(key -> this.verifySig(jsonWebSignature, (Key)key, "x5c-header certificate", signatureElement)).filter(Optional::isPresent).map(Optional::get)).orElseGet(() -> RbelJwtSignature.builder().isValid(RbelElement.wrap(null, signatureElement, false)).verifiedUsing(null).build()));
            RbelJwtFacet rbelJwtFacet = new RbelJwtFacet(headerElement, bodyElement, signatureElement);
            rbelElement.addFacet(rbelJwtFacet);
            rbelElement.addFacet(new RbelRootFacet<RbelJwtFacet>(rbelJwtFacet));
        }
        catch (JoseException joseException) {
            // empty catch block
        }
    }

    private Optional<PublicKey> tryToGetKeyFromX5cHeaderClaim(JsonWebSignature jsonWebSignature) {
        return Optional.ofNullable(jsonWebSignature.getCertificateChainHeaderValue()).map(list -> (X509Certificate)list.get(0)).map(Certificate::getPublicKey);
    }

    private JsonWebSignature initializeJws(RbelElement rbel) throws JoseException {
        JsonWebSignature jsonWebSignature = new JsonWebSignature();
        ProviderContext context = new ProviderContext();
        context.getSuppliedKeyProviderContext().setGeneralProvider("BC");
        jsonWebSignature.setProviderContext(context);
        jsonWebSignature.setCompactSerialization(rbel.getRawStringContent());
        return jsonWebSignature;
    }

    private Optional<RbelJwtSignature> verifySig(JsonWebSignature jsonWebSignature, Key key, String keyId, RbelElement signatureElement) {
        try {
            jsonWebSignature.setKey(key);
            this.tryToGetKeyFromX5cHeaderClaim(jsonWebSignature);
            if (jsonWebSignature.verifySignature()) {
                return Optional.of(RbelJwtSignature.builder().isValid(RbelElement.wrap(null, signatureElement, true)).verifiedUsing(RbelElement.wrap(null, signatureElement, keyId)).build());
            }
            return Optional.empty();
        }
        catch (JoseException e) {
            return Optional.empty();
        }
    }
}

