/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.jose;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelListFacet;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.key.RbelKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.JoseException;

public class RbelJwkReader
extends RbelConverterPlugin {
    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.CONTENT_ENRICHMENT;
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        List keysList = rbelElement.findRbelPathMembers("$..keys").stream().filter(element -> element.hasFacet(RbelJsonFacet.class)).filter(el -> el.hasFacet(RbelJsonFacet.class)).map(el -> el.getFacet(RbelListFacet.class)).filter(Optional::isPresent).map(Optional::get).map(RbelListFacet::getChildNodes).flatMap(Collection::stream).toList();
        for (RbelElement keyElement : keysList) {
            this.tryToConvertKeyAndAddToKeyManager(keyElement, converter);
        }
    }

    private void tryToConvertKeyAndAddToKeyManager(RbelElement keyElement, RbelConversionExecutor converter) {
        try {
            JsonWebKey jwk = JsonWebKey.Factory.newJwk((String)keyElement.getRawStringContent());
            converter.getRbelKeyManager().addKey(RbelKey.builder().key(jwk.getKey()).keyName(jwk.getKeyId()).precedence(200).build());
        }
        catch (RuntimeException | JoseException e) {
            keyElement.addFacet(RbelNoteFacet.builder().value("Unable to parse key: " + e.getMessage()).style(RbelNoteFacet.NoteStyling.WARN).build());
        }
    }
}

