/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.jose;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.facets.jose.RbelJweEncryptionInfo;
import de.gematik.rbellogger.facets.jose.RbelJweFacet;
import de.gematik.rbellogger.facets.pki.base64.RbelBase64JsonConverter;
import de.gematik.rbellogger.key.RbelKey;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(dependsOn={RbelBase64JsonConverter.class})
public class RbelJweConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelJweConverter.class);
    public static final int MAX_JWE_DOT_SEPARATOR_COUNT = 4;

    @Override
    public void consumeElement(RbelElement rbel, RbelConversionExecutor context) {
        Optional<JsonWebEncryption> jweOptional = this.initializeJwe(rbel);
        if (jweOptional.isEmpty()) {
            return;
        }
        JsonWebEncryption jwe = jweOptional.get();
        Optional<Pair<String, String>> correctKeyAndPayload = this.findCorrectKeyAndReturnPayload(context, jwe);
        RbelJweFacet jweFacet = correctKeyAndPayload.isEmpty() ? RbelJweFacet.builder().header(context.convertElement(jwe.getHeaders().getFullHeaderAsJsonString(), rbel)).body(context.convertElement("<Encrypted Payload>", rbel)).encryptionInfo(this.buildEncryptionInfo(false, null, rbel)).build() : RbelJweFacet.builder().header(context.convertElement(jwe.getHeaders().getFullHeaderAsJsonString(), rbel)).body(context.convertElement((String)correctKeyAndPayload.get().getValue(), rbel)).encryptionInfo(this.buildEncryptionInfo(true, (String)correctKeyAndPayload.get().getKey(), rbel)).build();
        rbel.addFacet(jweFacet);
        rbel.addFacet(new RbelRootFacet<RbelJweFacet>(jweFacet));
    }

    private RbelElement buildEncryptionInfo(boolean decryptable, String keyId, RbelElement jweElement) {
        RbelElement encryptionInfoElement = RbelElement.builder().parentNode(jweElement).rawContent(null).build();
        encryptionInfoElement.addFacet(RbelJweEncryptionInfo.builder().wasDecryptable(RbelElement.wrap(null, encryptionInfoElement, decryptable)).decryptedUsingKeyWithId(RbelElement.wrap(null, encryptionInfoElement, keyId)).build());
        return encryptionInfoElement;
    }

    private Optional<Pair<String, String>> findCorrectKeyAndReturnPayload(RbelConversionExecutor context, JsonWebEncryption jwe) {
        for (RbelKey keyEntry : context.getRbelKeyManager().getAllKeys().toList()) {
            try {
                jwe.setKey(keyEntry.getKey());
                return Optional.of(Pair.of((Object)keyEntry.getKeyName(), (Object)jwe.getPayload()));
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    private Optional<JsonWebEncryption> initializeJwe(RbelElement rbel) {
        int dotCount = rbel.getContent().countOccurrencesUpTo((byte)46, 5);
        if (2 > dotCount || dotCount > 4) {
            return Optional.empty();
        }
        return Optional.ofNullable(rbel.getRawStringContent()).map(RbelJweConverter::parseJweEncryption);
    }

    private static JsonWebEncryption parseJweEncryption(String content) {
        try {
            JsonWebEncryption receiverJwe = new JsonWebEncryption();
            receiverJwe.setDoKeyValidation(false);
            receiverJwe.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
            receiverJwe.setCompactSerialization(content);
            return receiverJwe;
        }
        catch (JoseException e) {
            return null;
        }
    }
}

