/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.facets.jackson.AbstractJacksonConverter;
import de.gematik.rbellogger.facets.jackson.RbelJsonFacet;
import de.gematik.rbellogger.util.RbelContent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class RbelJsonConverter
extends AbstractJacksonConverter<RbelJsonFacet> {
    private static final byte OPEN_OBJECT = 123;
    private static final byte CLOSE_OBJECT = 125;
    private static final byte OPEN_LIST = 91;
    private static final byte CLOSE_LIST = 93;

    public RbelJsonConverter() {
        super(new ObjectMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true), RbelJsonFacet.class);
    }

    @Override
    JsonNode convertContentUsingJackson(RbelElement target) throws IOException {
        return this.getMapper().readTree((Reader)new InputStreamReader(target.getContent().toInputStream(), target.getElementCharset()));
    }

    @Override
    RbelJsonFacet buildFacetForNode(JsonNode node) {
        return RbelJsonFacet.builder().jsonElement(node).build();
    }

    @Override
    boolean shouldElementBeConsidered(RbelElement target) {
        RbelContent content = target.getContent();
        return RbelJsonConverter.containsInRightOrder(content, (byte)123, (byte)125) || RbelJsonConverter.containsInRightOrder(content, (byte)91, (byte)93);
    }

    private static boolean containsInRightOrder(RbelContent content, byte open, byte close) {
        int openIndex = content.indexOf(open);
        return openIndex >= 0 && content.indexOf(close, openIndex) >= 0;
    }
}

