/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.GenericPrettyPrinter;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;

public class RbelCborFacet
implements RbelFacet {
    private static final GenericPrettyPrinter<ASN1Encodable> ASN1_PRETTY_PRINTER = new GenericPrettyPrinter<ASN1Encodable>(asn1 -> !(asn1 instanceof ASN1Sequence) && !(asn1 instanceof ASN1Set), Object::toString, asn1 -> StreamSupport.stream(((Iterable)asn1).spliterator(), false));
    private final RbelElement unparsedBytes;
    private final JsonNode node;

    @Override
    public RbelMultiMap<RbelElement> getChildElements() {
        return new RbelMultiMap<RbelElement>().with("unparsedBytes", this.unparsedBytes);
    }

    @ConstructorProperties(value={"unparsedBytes", "node"})
    @Generated
    RbelCborFacet(RbelElement unparsedBytes, JsonNode node) {
        this.unparsedBytes = unparsedBytes;
        this.node = node;
    }

    @Generated
    public static RbelCborFacetBuilder builder() {
        return new RbelCborFacetBuilder();
    }

    @Generated
    public RbelCborFacetBuilder toBuilder() {
        return new RbelCborFacetBuilder().unparsedBytes(this.unparsedBytes).node(this.node);
    }

    @Generated
    public RbelElement getUnparsedBytes() {
        return this.unparsedBytes;
    }

    @Generated
    public JsonNode getNode() {
        return this.node;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelCborFacet)) {
            return false;
        }
        RbelCborFacet other = (RbelCborFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$unparsedBytes = this.getUnparsedBytes();
        RbelElement other$unparsedBytes = other.getUnparsedBytes();
        if (this$unparsedBytes == null ? other$unparsedBytes != null : !this$unparsedBytes.equals(other$unparsedBytes)) {
            return false;
        }
        JsonNode this$node = this.getNode();
        JsonNode other$node = other.getNode();
        return !(this$node == null ? other$node != null : !this$node.equals(other$node));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelCborFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $unparsedBytes = this.getUnparsedBytes();
        result = result * 59 + ($unparsedBytes == null ? 43 : $unparsedBytes.hashCode());
        JsonNode $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelCborFacet(unparsedBytes=" + String.valueOf(this.getUnparsedBytes()) + ", node=" + String.valueOf(this.getNode()) + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelCborFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                String formatedJson = renderingToolkit.getObjectMapper().writeValueAsString((Object)renderingToolkit.shadeJson(element.getFacetOrFail(RbelCborFacet.class).node, Optional.empty(), element));
                for (Map.Entry<UUID, RbelHtmlRenderingToolkit.JsonNoteEntry> entry : renderingToolkit.getNoteTags().entrySet()) {
                    if (formatedJson.contains(entry.getValue().getStringToMatch() + ",")) {
                        formatedJson = formatedJson.replace(entry.getValue().getStringToMatch() + ",", entry.getValue().getTagForKeyReplacement().render() + "," + entry.getValue().getTagForValueReplacement().render());
                        continue;
                    }
                    if (!formatedJson.contains(entry.getValue().getStringToMatch())) continue;
                    formatedJson = formatedJson.replace(entry.getValue().getStringToMatch(), entry.getValue().getTagForKeyReplacement().render() + entry.getValue().getTagForValueReplacement().render());
                }
                return TagCreator.div((DomContent[])new DomContent[]{RbelHtmlRenderingToolkit.t1ms("CBOR").with(RbelHtmlRenderer.showContentButtonAndDialog(element, renderingToolkit)), TagCreator.pre((DomContent[])new DomContent[]{new UnescapedText(formatedJson)}).withClass("binary"), TagCreator.br(), RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with(renderingToolkit.convertNested(element)))});
            }
        });
    }

    @Generated
    public static class RbelCborFacetBuilder {
        @Generated
        private RbelElement unparsedBytes;
        @Generated
        private JsonNode node;

        @Generated
        RbelCborFacetBuilder() {
        }

        @Generated
        public RbelCborFacetBuilder unparsedBytes(RbelElement unparsedBytes) {
            this.unparsedBytes = unparsedBytes;
            return this;
        }

        @Generated
        public RbelCborFacetBuilder node(JsonNode node) {
            this.node = node;
            return this;
        }

        @Generated
        public RbelCborFacet build() {
            return new RbelCborFacet(this.unparsedBytes, this.node);
        }

        @Generated
        public String toString() {
            return "RbelCborFacet.RbelCborFacetBuilder(unparsedBytes=" + String.valueOf(this.unparsedBytes) + ", node=" + String.valueOf(this.node) + ")";
        }
    }
}

