/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelRootFacet;
import de.gematik.rbellogger.facets.jackson.AbstractJacksonConverter;
import de.gematik.rbellogger.facets.jackson.RbelCborFacet;
import java.io.IOException;

public class RbelCborConverter
extends AbstractJacksonConverter<RbelCborFacet> {
    public RbelCborConverter() {
        super((ObjectMapper)new CBORMapper(), RbelCborFacet.class);
    }

    @Override
    RbelCborFacet buildFacetForNode(JsonNode node) {
        return RbelCborFacet.builder().node(node).build();
    }

    @Override
    JsonNode convertContentUsingJackson(RbelElement target) throws IOException {
        if (target.hasFacet(RbelRootFacet.class)) {
            return null;
        }
        return this.getMapper().readTree(target.getContent().toInputStream());
    }
}

