/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.http.formdata;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.facets.http.RbelHttpHeaderFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.formdata.RbelHttpFormDataFacet;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class RbelHttpFormDataConverter
extends RbelConverterPlugin {
    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        if (this.isBodyOfFormDataRequest(rbelElement)) {
            RbelMultiMap formDataMap = Stream.of(rbelElement.getRawStringContent().split("&")).map(param -> param.split("=")).filter(params -> ((String[])params).length == 2).map(paramList -> Pair.of((Object)paramList[0], (Object)converter.convertElement(paramList[1], rbelElement))).collect(RbelMultiMap.COLLECTOR);
            rbelElement.addFacet(RbelHttpFormDataFacet.builder().formDataMap(formDataMap).build());
        }
    }

    private boolean isBodyOfFormDataRequest(RbelElement rbelElement) {
        return Optional.ofNullable(rbelElement).map(RbelElement::getParentNode).flatMap(el -> el.getFacet(RbelHttpMessageFacet.class)).map(RbelHttpMessageFacet::getHeader).flatMap(el -> el.getFacet(RbelHttpHeaderFacet.class)).filter(header -> header.hasValueMatching("Content-Type", "application/x-www-form-urlencoded")).isPresent();
    }
}

