/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.http;

import com.google.common.net.MediaType;
import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.data.core.RbelListFacet;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.data.core.RbelResponseFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.http.RbelHttpCodingConverter;
import de.gematik.rbellogger.facets.http.RbelHttpHeaderFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseFacet;
import de.gematik.rbellogger.util.RbelContent;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHttpResponseConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHttpResponseConverter.class);
    static final String CRLF = "\r\n";
    private static final byte[] CRLF_BYTES = "\r\n".getBytes(StandardCharsets.UTF_8);
    private static final String HTTP_PREFIX = "HTTP/";
    private static final byte[] HTTP_PREFIX_BYTES = "HTTP/".getBytes(StandardCharsets.UTF_8);
    private final boolean lenientParsingMode;
    public static final Map<String, RbelHttpCodingConverter> HTTP_CODINGS_MAP = Map.of("chunked", RbelHttpResponseConverter::decodeChunked, "deflate", RbelHttpResponseConverter::decodeDeflate, "gzip", RbelHttpResponseConverter::decodeGzip);

    private static byte[] decodeGzip(byte[] bytes, String eol, Charset charset) {
        byte[] byArray;
        log.atTrace().log(() -> "Decoding data with gzip");
        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(bytes));
        try {
            byArray = inputStream.readAllBytes();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RbelConversionException("Error while decoding gzip content", e);
            }
        }
        ((InputStream)inputStream).close();
        return byArray;
    }

    private static byte[] decodeDeflate(byte[] bytes, String eol, Charset charset) {
        byte[] byArray;
        log.atTrace().log(() -> "Decoding data with deflate");
        InflaterInputStream inputStream = new InflaterInputStream(new ByteArrayInputStream(bytes));
        try {
            byArray = inputStream.readAllBytes();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RbelConversionException("Error while decoding gzip content", e);
            }
        }
        ((InputStream)inputStream).close();
        return byArray;
    }

    private static byte[] decodeChunked(byte[] inputData, String eol, Charset charset) {
        log.atTrace().log(() -> "Decoding data with chunked encoding");
        int chunkSeparator = new String(inputData, charset).indexOf(eol) + eol.length();
        int indexOfChunkTerminator = RbelHttpResponseConverter.determineEndOfChunkedBody(RbelContent.of(inputData), 0, eol) - 7;
        if (indexOfChunkTerminator >= 0) {
            return Arrays.copyOfRange(inputData, Math.min(inputData.length, chunkSeparator), indexOfChunkTerminator);
        }
        throw new RbelConversionException("Detected incorrect use of chunked encoding: Chunked was given as transfer-encoding, but the chunk-separator could not be found in the content. Message will not be parsed.");
    }

    public RbelHttpResponseConverter(RbelConfiguration configuration) {
        this.lenientParsingMode = Optional.ofNullable(configuration.getLenientHttpParsing()).orElseGet(() -> ((TigerTypedConfigurationKey)TigerConfigurationKeys.LENIENT_HTTP_PARSING).getValueOrDefault());
    }

    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.PROTOCOL_PARSING;
    }

    @Override
    public boolean skipParsingOversizedContent() {
        return true;
    }

    @Override
    public void consumeElement(RbelElement targetElement, RbelConversionExecutor converter) {
        RbelContent content = targetElement.getContent();
        if (!content.startsWith(HTTP_PREFIX_BYTES)) {
            return;
        }
        new Parser(targetElement, converter, content).parse();
    }

    public RbelElement extractHeaderFromMessage(RbelElement rbel, RbelConversionExecutor converter, String eol, String content) {
        int endOfBodyPosition = content.indexOf(eol + eol);
        int endOfFirstLine = content.indexOf(eol) + eol.length();
        endOfBodyPosition = endOfBodyPosition < 0 ? content.length() : (endOfBodyPosition += 2 * eol.length());
        List<String> headerList = Arrays.stream(content.substring(endOfFirstLine, endOfBodyPosition).split(eol)).filter(line -> !line.isEmpty() && !line.startsWith(HTTP_PREFIX)).toList();
        RbelElement headerElement = new RbelElement(String.join((CharSequence)eol, headerList).getBytes(rbel.getElementCharset()), rbel);
        RbelMultiMap headerMap = headerList.stream().map(line -> this.parseStringToKeyValuePair((String)line, converter, headerElement)).collect(RbelMultiMap.COLLECTOR);
        headerElement.addFacet(new RbelHttpHeaderFacet(headerMap));
        return headerElement;
    }

    private Optional<Charset> strictParsingOfCharset(String s) {
        try {
            return Optional.ofNullable(s).map(MediaType::parse).map(MediaType::charset).filter(com.google.common.base.Optional::isPresent).map(com.google.common.base.Optional::get);
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    Optional<Charset> findCharsetInHeader(RbelHttpHeaderFacet headerMap) {
        return headerMap.getCaseInsensitiveMatches("Content-Type").map(RbelElement::getRawStringContent).filter(Objects::nonNull).map(str -> this.strictParsingOfCharset((String)str).orElse(this.guessCharset((String)str))).findFirst();
    }

    private Charset guessCharset(String str) {
        String lowerCaseString = str.toLowerCase();
        return Stream.of(StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII, StandardCharsets.UTF_16).filter(charset -> charset.aliases().stream().map(String::toLowerCase).anyMatch(lowerCaseString::contains)).findFirst().orElse(StandardCharsets.UTF_8);
    }

    protected AbstractMap.SimpleImmutableEntry<String, RbelElement> parseStringToKeyValuePair(String line, RbelConversionExecutor context, RbelElement headerElement) {
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Header malformed: '" + line + "'");
        }
        String key = line.substring(0, colon).trim();
        String value = line.substring(colon + 1).trim();
        Charset elementCharset = headerElement.getElementCharset();
        RbelElement rbelElement = context.convertElement(new RbelElement(value.getBytes(elementCharset), headerElement));
        if (value.contains(",")) {
            ArrayList<RbelElement> childNodes = new ArrayList<RbelElement>();
            rbelElement.addFacet(new RbelListFacet(childNodes));
            for (String part : value.split(",")) {
                childNodes.add(context.convertElement(new RbelElement(part.trim().getBytes(elementCharset), rbelElement)));
            }
        }
        return new AbstractMap.SimpleImmutableEntry<String, RbelElement>(key, rbelElement);
    }

    public byte[] applyCodings(byte[] inputData, RbelHttpHeaderFacet headerMap, String eol, Charset charset, String codingKey) {
        List<RbelHttpCodingConverter> codingConverters = headerMap.getCaseInsensitiveMatches(codingKey).map(RbelElement::getRawStringContent).filter(Objects::nonNull).map(s -> s.split(",")).flatMap(Arrays::stream).map(String::toLowerCase).map(String::trim).map(encoding -> {
            if (!HTTP_CODINGS_MAP.containsKey(encoding)) {
                throw new RbelConversionException("Unsupported encoding found in HTTP header: " + encoding);
            }
            log.atTrace().addArgument(() -> encoding).log("Adding decoder for encoding: {}");
            return HTTP_CODINGS_MAP.get(encoding);
        }).toList();
        byte[] data = inputData;
        for (RbelHttpCodingConverter codingConverter : codingConverters) {
            data = codingConverter.decode(data, eol, charset);
        }
        return data;
    }

    public byte[] extractBodyData(RbelElement targetElement, int bodyDataStartOffset, RbelHttpHeaderFacet headerMap, String eol) {
        RbelContent content;
        int contentEndIndex = this.calculateContentLength(targetElement, bodyDataStartOffset, headerMap, eol);
        if (contentEndIndex > (content = targetElement.getContent()).size()) {
            throw new RbelConversionException("Hit end of messages while trying to determine body size.");
        }
        byte[] inputData = content.toByteArray(Math.min(bodyDataStartOffset, contentEndIndex), contentEndIndex);
        Charset elementCharset = targetElement.getElementCharset();
        return this.applyCodings(this.applyCodings(inputData, headerMap, eol, elementCharset, "Content-Encoding"), headerMap, eol, elementCharset, "Transfer-Encoding");
    }

    private int calculateContentLength(RbelElement targetElement, int bodyDataStartOffset, RbelHttpHeaderFacet headerMap, String eol) {
        boolean messageBodyIsPresent;
        RbelContent content = targetElement.getContent();
        boolean bl = messageBodyIsPresent = bodyDataStartOffset < content.size();
        if (messageBodyIsPresent) {
            return this.parseBody(targetElement, bodyDataStartOffset, headerMap, eol, content);
        }
        if (bodyDataStartOffset == content.size()) {
            return bodyDataStartOffset;
        }
        if (!this.lenientParsingMode) {
            targetElement.addFacet(RbelNoteFacet.builder().style(this.styleParsingError(targetElement)).value("No body found in HTTP message (Does the message terminate with correct line breaks?)").build());
            if (this.isTcpMessage(targetElement)) {
                throw new RbelConversionException("No body found in HTTP message");
            }
        }
        return content.size();
    }

    private int parseBody(RbelElement targetElement, int bodyDataStartOffset, RbelHttpHeaderFacet headerMap, String eol, RbelContent content) {
        Optional<RbelElement> contentLengthHeader = headerMap.getCaseInsensitiveMatches("Content-Length").findAny();
        Optional<RbelElement> transferEncodingHeader = headerMap.getCaseInsensitiveMatches("Transfer-Encoding").findAny();
        if (contentLengthHeader.isPresent()) {
            int endOfBodyIndex = bodyDataStartOffset + RbelHttpResponseConverter.parseContentLengthHeader(contentLengthHeader.get());
            if (endOfBodyIndex > content.size()) {
                throw new RbelConversionException("Body-length exceeds available content (Wanted " + endOfBodyIndex + " bytes, but only " + content.size() + " bytes available)");
            }
            targetElement.setUsedBytes(endOfBodyIndex);
            return endOfBodyIndex;
        }
        if (transferEncodingHeader.isPresent()) {
            int endOfChunkedBody = RbelHttpResponseConverter.determineEndOfChunkedBody(content, bodyDataStartOffset, eol);
            targetElement.setUsedBytes(endOfChunkedBody);
            return endOfChunkedBody;
        }
        targetElement.setUsedBytes(bodyDataStartOffset);
        return bodyDataStartOffset;
    }

    private static int parseContentLengthHeader(RbelElement contentLengthHeader) {
        return Optional.ofNullable(contentLengthHeader.getRawStringContent()).map(Integer::parseInt).orElseThrow();
    }

    private static int determineEndOfChunkedBody(RbelContent content, int bodyDataStartOffset, String eol) {
        int currentChunkSize;
        byte[] bytes = eol.getBytes();
        int endOfChunkedBody = bodyDataStartOffset;
        do {
            byte[] currentChunkSizeData = content.toByteArray(endOfChunkedBody, content.indexOf(bytes, endOfChunkedBody));
            try {
                currentChunkSize = HexFormat.fromHexDigits(new String(currentChunkSizeData));
            }
            catch (NumberFormatException e) {
                throw new RbelConversionException("Illegal chunked-encoding detected: '" + new String(currentChunkSizeData) + "' is not a valid integer", e);
            }
            endOfChunkedBody += currentChunkSizeData.length + 2 + currentChunkSize + 2;
        } while (currentChunkSize > 0);
        return endOfChunkedBody;
    }

    RbelNoteFacet.NoteStyling styleParsingError(RbelElement targetElement) {
        return this.isTcpMessage(targetElement) ? RbelNoteFacet.NoteStyling.WARN : RbelNoteFacet.NoteStyling.INFO;
    }

    boolean isTcpMessage(RbelElement targetElement) {
        return targetElement.hasFacet(RbelTcpIpMessageFacet.class);
    }

    public Optional<String> findEolInHttpMessage(RbelContent content) {
        if (content.indexOf(CRLF_BYTES) >= 0) {
            return Optional.of(CRLF);
        }
        if (content.indexOf((byte)10) >= 0) {
            return Optional.of("\n");
        }
        return Optional.empty();
    }

    void checkEolValue(String eol, RbelElement targetElement) {
        if (!eol.equals(CRLF)) {
            targetElement.addFacet(RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.INFO).value("Non-standard line endings detected. Expected CRLF, but found: " + Hex.toHexString((byte[])eol.getBytes())).build());
        }
    }

    @Generated
    public boolean isLenientParsingMode() {
        return this.lenientParsingMode;
    }

    private class Parser {
        private final RbelElement targetElement;
        private final RbelConversionExecutor converter;
        private final RbelContent content;

        private void parse() {
            Optional<String> eolOpt = RbelHttpResponseConverter.this.findEolInHttpMessage(this.content);
            if (eolOpt.isEmpty()) {
                return;
            }
            String eol = eolOpt.get();
            RbelHttpResponseConverter.this.checkEolValue(eol, this.targetElement);
            Optional<Integer> endOfHeaderIndexOpt = this.findEndOfHeaderIndex(eol);
            if (endOfHeaderIndexOpt.isEmpty()) {
                if (RbelHttpResponseConverter.this.lenientParsingMode || !RbelHttpResponseConverter.this.isTcpMessage(this.targetElement)) {
                    endOfHeaderIndexOpt = Optional.of(this.content.size());
                } else {
                    this.targetElement.addFacet(RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.WARN).value("Unable to determine end of HTTP header. Does the header end with double CRLF?").build());
                    return;
                }
            }
            Integer endOfHeaderIndex = endOfHeaderIndexOpt.get();
            String stringContent = this.targetElement.getRawStringContent();
            if (stringContent == null) {
                return;
            }
            RbelElement headerElement = RbelHttpResponseConverter.this.extractHeaderFromMessage(this.targetElement, this.converter, eol, stringContent);
            RbelHttpHeaderFacet httpHeaderFacet = headerElement.getFacetOrFail(RbelHttpHeaderFacet.class);
            byte[] rawBodyData = RbelHttpResponseConverter.this.extractBodyData(this.targetElement, endOfHeaderIndex, httpHeaderFacet, eol);
            RbelElement bodyElement = new RbelElement(rawBodyData, this.targetElement, RbelHttpResponseConverter.this.findCharsetInHeader(httpHeaderFacet));
            RbelElement responseCode = this.extractResponseCodeFromMessage(stringContent);
            RbelHttpResponseFacet rbelHttpResponse = RbelHttpResponseFacet.builder().responseCode(responseCode).reasonPhrase(this.extractReasonPhraseFromMessage(stringContent)).build();
            this.targetElement.addFacet(rbelHttpResponse);
            this.targetElement.addFacet(new RbelResponseFacet(responseCode.getRawStringContent()));
            RbelElement httpVersion = new RbelElement(stringContent.substring(0, stringContent.indexOf(" ")).getBytes(), this.targetElement);
            this.targetElement.addFacet(RbelHttpMessageFacet.builder().header(headerElement).body(bodyElement).httpVersion(httpVersion).build());
            this.converter.convertElement(bodyElement);
        }

        private Optional<Integer> findEndOfHeaderIndex(String eol) {
            int endOfHeadIndex = this.content.indexOf((eol + eol).getBytes());
            if (endOfHeadIndex == -1) {
                return Optional.empty();
            }
            return Optional.of(endOfHeadIndex += 2 * eol.length());
        }

        private RbelElement extractResponseCodeFromMessage(String content) {
            return RbelElement.builder().parentNode(this.targetElement).rawContent(content.split("\\s")[1].getBytes(StandardCharsets.UTF_8)).build();
        }

        private RbelElement extractReasonPhraseFromMessage(String content) {
            String[] responseStatusLineSplit = content.split("\\r\\n")[0].trim().split("\\s", 3);
            if (responseStatusLineSplit.length == 2) {
                return RbelElement.builder().parentNode(this.targetElement).build();
            }
            return RbelElement.builder().parentNode(this.targetElement).rawContent(responseStatusLineSplit[2].trim().getBytes(this.targetElement.getElementCharset())).build();
        }

        @ConstructorProperties(value={"targetElement", "converter", "content"})
        @Generated
        public Parser(RbelElement targetElement, RbelConversionExecutor converter, RbelContent content) {
            this.targetElement = targetElement;
            this.converter = converter;
            this.content = content;
        }
    }
}

