/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.http;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelNoteFacet;
import de.gematik.rbellogger.data.core.RbelRequestFacet;
import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.facets.http.RbelHttpHeaderFacet;
import de.gematik.rbellogger.facets.http.RbelHttpMessageFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseConverter;
import de.gematik.rbellogger.util.RbelContent;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHttpRequestConverter
extends RbelHttpResponseConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHttpRequestConverter.class);
    private static final Set<String> HTTP_METHODS = Set.of("GET", "POST", "PUT", "HEAD", "OPTIONS", "PATCH", "DELETE", "TRACE", "CONNECT");
    private static final byte[] HTTP_11_BYTES = "HTTP/1.1".getBytes();

    public RbelHttpRequestConverter(RbelConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void consumeElement(RbelElement targetElement, RbelConversionExecutor converter) {
        RbelContent content = targetElement.getContent();
        if (!this.startsWithHttpVerb(content)) {
            return;
        }
        Optional<String> eolOpt = this.findEolInHttpMessage(content);
        if (eolOpt.isEmpty()) {
            return;
        }
        String eol = eolOpt.get();
        Optional<RequestFirstLineParts> firstLineOpt = RbelHttpRequestConverter.extractFirstLine(targetElement, eol, content);
        if (firstLineOpt.isEmpty()) {
            return;
        }
        this.checkEolValue(eol, targetElement);
        int endOfHeadIndex = RbelHttpRequestConverter.findEndOfHeadIndex(content, eol);
        RequestFirstLineParts firstLineParts = firstLineOpt.get();
        String path = firstLineParts.path;
        String method = firstLineParts.method;
        RbelElement httpVersion = firstLineParts.version;
        RbelElement pathElement = converter.convertElement(path, targetElement);
        String stringContent = targetElement.getRawStringContent();
        if (stringContent == null) {
            return;
        }
        RbelElement headerElement = this.extractHeaderFromMessage(targetElement, converter, eol, stringContent);
        RbelHttpHeaderFacet httpHeader = headerElement.getFacetOrFail(RbelHttpHeaderFacet.class);
        this.verifyHeader(httpHeader, httpVersion, targetElement);
        byte[] bodyData = this.extractBodyData(targetElement, endOfHeadIndex + 2 * eol.length(), httpHeader, eol);
        RbelElement bodyElement = new RbelElement(bodyData, targetElement, this.findCharsetInHeader(httpHeader));
        RbelHttpRequestFacet httpRequest = RbelHttpRequestFacet.builder().method(converter.convertElement(method, targetElement)).path(pathElement).build();
        targetElement.addFacet(httpRequest);
        targetElement.addFacet(new RbelRequestFacet(method + " " + path, true));
        targetElement.addFacet(RbelHttpMessageFacet.builder().header(headerElement).body(bodyElement).httpVersion(httpVersion).build());
        converter.convertElement(bodyElement);
    }

    private void verifyHeader(RbelHttpHeaderFacet httpHeader, RbelElement httpVersion, RbelElement targetElement) {
        if (httpVersion.getContent().startsWith(HTTP_11_BYTES) && httpHeader.getCaseInsensitiveMatches("host").findAny().isEmpty()) {
            targetElement.addFacet(RbelNoteFacet.builder().value("HTTP/1.1 request does not contain Host header").style(this.styleParsingError(targetElement)).build());
            if (!this.isLenientParsingMode() && this.isTcpMessage(targetElement)) {
                throw new RbelConversionException("HTTP/1.1 request does not contain Host header");
            }
        }
    }

    private static Optional<RequestFirstLineParts> extractFirstLine(RbelElement targetElement, String eol, RbelContent content) {
        int firstEndLineIndex = content.indexOf(eol.getBytes());
        String firstLine = new String(content.toByteArray(0, firstEndLineIndex), targetElement.getElementCharset());
        String[] firstLineParts = StringUtils.split((String)firstLine, (String)" ", (int)3);
        if (firstLineParts.length != 3) {
            return Optional.empty();
        }
        if (!firstLineParts[2].startsWith("HTTP/")) {
            return Optional.empty();
        }
        String method = firstLineParts[0];
        String path = firstLineParts[1];
        RbelElement httpVersion = new RbelElement(firstLineParts[2].getBytes(), targetElement);
        return Optional.of(RequestFirstLineParts.builder().method(method).path(path).version(httpVersion).build());
    }

    private static int findEndOfHeadIndex(RbelContent content, String eol) {
        int endOfHeadIndex = content.indexOf((eol + eol).getBytes());
        if (endOfHeadIndex < 0) {
            endOfHeadIndex = content.size();
        }
        return endOfHeadIndex;
    }

    public boolean startsWithHttpVerb(RbelContent data) {
        if (data.isEmpty()) {
            return false;
        }
        String firstLine = new String(data.toByteArray(0, Math.min(8, data.size())), StandardCharsets.US_ASCII);
        String method = firstLine.split(" ", 2)[0];
        return HTTP_METHODS.contains(method) && data.size() > method.length() && data.get(method.length()) == 32;
    }

    private static class RequestFirstLineParts {
        String method;
        String path;
        RbelElement version;

        @ConstructorProperties(value={"method", "path", "version"})
        @Generated
        RequestFirstLineParts(String method, String path, RbelElement version) {
            this.method = method;
            this.path = path;
            this.version = version;
        }

        @Generated
        public static RequestFirstLinePartsBuilder builder() {
            return new RequestFirstLinePartsBuilder();
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public RbelElement getVersion() {
            return this.version;
        }

        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setVersion(RbelElement version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestFirstLineParts)) {
                return false;
            }
            RequestFirstLineParts other = (RequestFirstLineParts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            RbelElement this$version = this.getVersion();
            RbelElement other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestFirstLineParts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            RbelElement $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RbelHttpRequestConverter.RequestFirstLineParts(method=" + this.getMethod() + ", path=" + this.getPath() + ", version=" + String.valueOf(this.getVersion()) + ")";
        }

        @Generated
        public static class RequestFirstLinePartsBuilder {
            @Generated
            private String method;
            @Generated
            private String path;
            @Generated
            private RbelElement version;

            @Generated
            RequestFirstLinePartsBuilder() {
            }

            @Generated
            public RequestFirstLinePartsBuilder method(String method) {
                this.method = method;
                return this;
            }

            @Generated
            public RequestFirstLinePartsBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public RequestFirstLinePartsBuilder version(RbelElement version) {
                this.version = version;
                return this;
            }

            @Generated
            public RequestFirstLineParts build() {
                return new RequestFirstLineParts(this.method, this.path, this.version);
            }

            @Generated
            public String toString() {
                return "RbelHttpRequestConverter.RequestFirstLineParts.RequestFirstLinePartsBuilder(method=" + this.method + ", path=" + this.path + ", version=" + String.valueOf(this.version) + ")";
            }
        }
    }
}

