/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.http;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.converter.ConverterInfo;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.core.RbelHostnameFacet;
import de.gematik.rbellogger.data.core.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.core.TracingMessagePairFacet;
import de.gematik.rbellogger.facets.http.RbelHttpRequestFacet;
import de.gematik.rbellogger.facets.http.RbelHttpResponseFacet;
import de.gematik.rbellogger.util.RbelSocketAddress;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConverterInfo(addAutomatically=false)
public class RbelHttpPairingInBinaryChannelConverter
extends RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHttpPairingInBinaryChannelConverter.class);

    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.CONTENT_PARSING;
    }

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        if (rbelElement.getParentNode() != null) {
            return;
        }
        if (rbelElement.hasFacet(RbelHttpResponseFacet.class)) {
            converter.getPreviousMessagesInSameConnectionAs(rbelElement).filter(e -> e.hasFacet(RbelHttpRequestFacet.class)).findFirst().ifPresent(e -> RbelHttpPairingInBinaryChannelConverter.updateHttpFacetsWithPairedMessages(e, rbelElement));
        }
    }

    private static void updateHttpFacetsWithPairedMessages(RbelElement request, RbelElement response) {
        Optional<RbelTcpIpMessageFacet> requestTcpFacet = request.getFacet(RbelTcpIpMessageFacet.class);
        Optional<RbelTcpIpMessageFacet> responseTcpFacet = response.getFacet(RbelTcpIpMessageFacet.class);
        if (requestTcpFacet.isPresent() && responseTcpFacet.isPresent() && RbelHttpPairingInBinaryChannelConverter.senderAndReceiverMatch(requestTcpFacet.get(), responseTcpFacet.get()) && !request.hasFacet(TracingMessagePairFacet.class) && !response.hasFacet(TracingMessagePairFacet.class)) {
            response.addFacet(new TracingMessagePairFacet(response, request));
            request.addFacet(new TracingMessagePairFacet(response, request));
        }
    }

    private static boolean senderAndReceiverMatch(RbelTcpIpMessageFacet request, RbelTcpIpMessageFacet response) {
        return Objects.equals(RbelHttpPairingInBinaryChannelConverter.getHostname(request.getSender()), RbelHttpPairingInBinaryChannelConverter.getHostname(response.getReceiver())) && Objects.equals(RbelHttpPairingInBinaryChannelConverter.getHostname(request.getReceiver()), RbelHttpPairingInBinaryChannelConverter.getHostname(response.getSender()));
    }

    private static RbelSocketAddress getHostname(RbelElement hostnameElement) {
        return hostnameElement.getFacet(RbelHostnameFacet.class).map(RbelHostnameFacet::toRbelSocketAddress).orElse(null);
    }
}

