/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.http;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.facets.http.RbelBearerTokenFacet;
import de.gematik.rbellogger.util.RbelContent;
import java.nio.charset.StandardCharsets;

public class RbelBearerTokenConverter
extends RbelConverterPlugin {
    private static final byte[] BEARER_TOKEN_PREFIX = "Bearer ".getBytes(StandardCharsets.UTF_8);

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
        RbelContent content = rbelElement.getContent();
        if (content.startsWith(BEARER_TOKEN_PREFIX)) {
            RbelElement bearerTokenElement = converter.convertElement(content.subArray(BEARER_TOKEN_PREFIX.length, content.size()), rbelElement);
            rbelElement.addFacet(new RbelBearerTokenFacet(bearerTokenElement));
        }
    }
}

