/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.facets.cetp;

import de.gematik.rbellogger.RbelConversionExecutor;
import de.gematik.rbellogger.RbelConversionPhase;
import de.gematik.rbellogger.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.facets.cetp.RbelCetpFacet;
import de.gematik.rbellogger.util.RbelContent;
import java.nio.ByteBuffer;

public class RbelCetpConverter
extends RbelConverterPlugin {
    private static final byte[] CETP_INTRO_MARKER = "CETP".getBytes();
    public static final int MIN_CETP_MESSAGE_LENGTH = CETP_INTRO_MARKER.length + 4;

    @Override
    public RbelConversionPhase getPhase() {
        return RbelConversionPhase.PROTOCOL_PARSING;
    }

    @Override
    public void consumeElement(RbelElement targetElement, RbelConversionExecutor converter) {
        RbelContent content = targetElement.getContent();
        long contentSize = targetElement.getSize();
        if (targetElement.getSize() < (long)MIN_CETP_MESSAGE_LENGTH || !content.startsWith(CETP_INTRO_MARKER)) {
            return;
        }
        byte[] messageLengthBytes = content.toByteArray(CETP_INTRO_MARKER.length, MIN_CETP_MESSAGE_LENGTH);
        int messageLength = ByteBuffer.wrap(messageLengthBytes).getInt();
        if (contentSize < (long)(MIN_CETP_MESSAGE_LENGTH + messageLength)) {
            return;
        }
        RbelContent messageBody = content.subArray(MIN_CETP_MESSAGE_LENGTH, MIN_CETP_MESSAGE_LENGTH + messageLength);
        RbelCetpFacet cetpFacet = RbelCetpFacet.builder().menuInfoString("CETP").messageLength(RbelElement.wrap(messageLengthBytes, targetElement, messageLength)).body(RbelElement.builder().content(messageBody).parentNode(targetElement).build()).build();
        targetElement.addFacet(cetpFacet);
        targetElement.setUsedBytes(MIN_CETP_MESSAGE_LENGTH + messageLength);
    }

    public static class RbelCetpBodyConverter
    extends RbelConverterPlugin {
        @Override
        public void consumeElement(RbelElement rbelElement, RbelConversionExecutor converter) {
            rbelElement.getFacet(RbelCetpFacet.class).ifPresent(cetpFacet -> converter.convertElement(cetpFacet.getBody()));
        }
    }
}

